/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.Context;
import android.os.Binder;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.internal.zzq;
import com.google.android.gms.auth.api.signin.internal.zzy;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;

public final class zzv
extends zzq {
    private final Context mContext;

    public zzv(Context context) {
        this.mContext = context;
    }

    @Override
    public final void zzmK() {
        if (!GooglePlayServicesUtil.zzf((Context)this.mContext, (int)Binder.getCallingUid())) {
            int n = Binder.getCallingUid();
            throw new SecurityException(new StringBuilder(52).append("Calling UID ").append(n).append(" is not Google Play services.").toString());
        }
        zzv zzv2 = this;
        zzy zzy2 = zzy.zzaj((Context)zzv2.mContext);
        GoogleSignInAccount googleSignInAccount = zzy2.zzmN();
        GoogleSignInOptions googleSignInOptions = GoogleSignInOptions.DEFAULT_SIGN_IN;
        if (googleSignInAccount != null) {
            googleSignInOptions = zzy2.zzmO();
        }
        GoogleApiClient googleApiClient = new GoogleApiClient.Builder(zzv2.mContext).addApi(Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions.HasOptions)googleSignInOptions).build();
        try {
            if (googleApiClient.blockingConnect().isSuccess()) {
                if (googleSignInAccount != null) {
                    Auth.GoogleSignInApi.revokeAccess(googleApiClient);
                } else {
                    googleApiClient.clearDefaultAccountAndReconnect();
                }
            }
            return;
        }
        finally {
            googleApiClient.disconnect();
        }
    }
}

