/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzb;
import com.google.android.gms.auth.api.signin.internal.zzx;
import com.google.android.gms.auth.api.signin.internal.zzy;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private zzy zzedf;
    private boolean zzedg = false;
    private SignInConfiguration zzedh;
    private boolean zzedi;
    private int zzedj;
    private Intent zzedk;

    public SignInHubActivity() {
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzedf = zzy.zzbm((Context)this);
        Intent intent = this.getIntent();
        if (!"com.google.android.gms.auth.GOOGLE_SIGN_IN".equals(intent.getAction())) {
            String string = String.valueOf(intent.getAction());
            Log.e((String)"AuthSignInClient", (String)(string.length() != 0 ? "Unknown action: ".concat(string) : new String("Unknown action: ")));
            this.finish();
        }
        this.zzedh = (SignInConfiguration)intent.getParcelableExtra("config");
        if (this.zzedh == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        if (bundle == null) {
            Intent intent2 = new Intent("com.google.android.gms.auth.GOOGLE_SIGN_IN");
            SignInHubActivity signInHubActivity = this;
            intent2.setPackage("com.google.android.gms");
            intent2.putExtra("config", (Parcelable)signInHubActivity.zzedh);
            try {
                signInHubActivity.startActivityForResult(intent2, 40962);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                signInHubActivity.zzedg = true;
                Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
                signInHubActivity.zzay(17);
                return;
            }
        }
        this.zzedi = bundle.getBoolean("signingInGoogleApiClients");
        if (this.zzedi) {
            this.zzedj = bundle.getInt("signInResultCode");
            this.zzedk = (Intent)bundle.getParcelable("signInResultData");
            this.zzaaq();
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", this.zzedi);
        if (this.zzedi) {
            bundle.putInt("signInResultCode", this.zzedj);
            bundle.putParcelable("signInResultData", (Parcelable)this.zzedk);
        }
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        if (this.zzedg) {
            return;
        }
        this.setResult(0);
        switch (n) {
            case 40962: {
                Intent intent2 = intent;
                SignInHubActivity signInHubActivity = this;
                if (intent2 != null) {
                    SignInAccount signInAccount = (SignInAccount)intent2.getParcelableExtra("signInAccount");
                    if (signInAccount != null && signInAccount.zzaah() != null) {
                        GoogleSignInAccount googleSignInAccount = signInAccount.zzaah();
                        signInHubActivity.zzedf.zza(googleSignInAccount, signInHubActivity.zzedh.zzaap());
                        intent2.removeExtra("signInAccount");
                        intent2.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                        signInHubActivity.zzedi = true;
                        signInHubActivity.zzedj = n2;
                        signInHubActivity.zzedk = intent2;
                        signInHubActivity.zzaaq();
                        return;
                    }
                    if (intent2.hasExtra("errorCode")) {
                        int n3 = intent2.getIntExtra("errorCode", 8);
                        signInHubActivity.zzay(n3);
                        return;
                    }
                }
                signInHubActivity.zzay(8);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return true;
    }

    private final void zzaaq() {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zza(this, null));
    }

    private final void zzay(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
    }

    final class zza
    implements LoaderManager.LoaderCallbacks<Void> {
        private /* synthetic */ SignInHubActivity zzedl;

        private zza(SignInHubActivity signInHubActivity) {
            this.zzedl = signInHubActivity;
        }

        public final Loader<Void> onCreateLoader(int n, Bundle bundle) {
            return new zzb((Context)this.zzedl, GoogleApiClient.zzafn());
        }

        public final void onLoaderReset(Loader<Void> loader) {
        }

        public final /* synthetic */ void onLoadFinished(Loader loader, Object object) {
            zza zza2 = this;
            zza2.zzedl.setResult(zza2.zzedl.zzedj, zza2.zzedl.zzedk);
            zza2.zzedl.finish();
        }

        /* synthetic */ zza(SignInHubActivity signInHubActivity, zzx zzx2) {
            this(signInHubActivity);
        }
    }
}

