/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Credential
extends zzbfm
implements ReflectedParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    private final String zzbuz;
    @Nullable
    private final String mName;
    @Nullable
    private final Uri zzeew;
    private final List<IdToken> zzeex;
    @Nullable
    private final String zzeey;
    @Nullable
    private final String zzeem;
    @Nullable
    private final String zzeez;
    @Nullable
    private final String zzefa;
    @Nullable
    private final String zzefb;
    @Nullable
    private final String zzefc;

    /*
     * Unable to fully structure code
     */
    Credential(String var1_1, String var2_2, Uri var3_3, List<IdToken> var4_4, String var5_5, String var6_6, String var7_7, String var8_8, String var9_9, String var10_10) {
        block8: {
            super();
            var11_11 = ((String)zzbq.checkNotNull((Object)var1_1, (Object)"credential identifier cannot be null")).trim();
            zzbq.zzh((String)var11_11, (Object)"credential identifier cannot be empty");
            if (var5_5 != null && TextUtils.isEmpty((CharSequence)var5_5)) {
                throw new IllegalArgumentException("Password must not be empty if set");
            }
            if (var6_6 == null) break block8;
            var12_12 = var6_6;
            if (TextUtils.isEmpty((CharSequence)var12_12)) ** GOTO lbl-1000
            var13_13 = Uri.parse((String)var12_12);
            if (!var13_13.isAbsolute() || !var13_13.isHierarchical() || TextUtils.isEmpty((CharSequence)var13_13.getScheme()) || TextUtils.isEmpty((CharSequence)var13_13.getAuthority())) {
                v0 = false;
            } else if ("http".equalsIgnoreCase(var13_13.getScheme()) || "https".equalsIgnoreCase(var13_13.getScheme())) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!Boolean.valueOf(v0).booleanValue()) {
                throw new IllegalArgumentException("Account type must be a valid Http/Https URI");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)var6_6) && !TextUtils.isEmpty((CharSequence)var5_5)) {
            throw new IllegalArgumentException("Password and AccountType are mutually exclusive");
        }
        if (var2_2 != null && TextUtils.isEmpty((CharSequence)var2_2.trim())) {
            var2_2 = null;
        }
        this.mName = var2_2;
        this.zzeew = var3_3;
        this.zzeex = var4_4 == null ? Collections.emptyList() : Collections.unmodifiableList(var4_4);
        this.zzbuz = var11_11;
        this.zzeey = var5_5;
        this.zzeem = var6_6;
        this.zzeez = var7_7;
        this.zzefa = var8_8;
        this.zzefb = var9_9;
        this.zzefc = var10_10;
    }

    public String getId() {
        return this.zzbuz;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzeew;
    }

    public List<IdToken> getIdTokens() {
        return this.zzeex;
    }

    @Nullable
    public String getPassword() {
        return this.zzeey;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.zzeez;
    }

    @Nullable
    public String getAccountType() {
        return this.zzeem;
    }

    @Nullable
    public String getGivenName() {
        return this.zzefb;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzefc;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Credential credential = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (String)credential.getId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)credential.getName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (Parcelable)credential.getProfilePictureUri(), (int)n, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)4, credential.getIdTokens(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (String)credential.getPassword(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (String)credential.getAccountType(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (String)credential.getGeneratedPassword(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)8, (String)credential.zzefa, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)9, (String)credential.getGivenName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)10, (String)credential.getFamilyName(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.zzbuz, (CharSequence)credential.zzbuz) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzbg.equal((Object)this.zzeew, (Object)credential.zzeew) && TextUtils.equals((CharSequence)this.zzeey, (CharSequence)credential.zzeey) && TextUtils.equals((CharSequence)this.zzeem, (CharSequence)credential.zzeem) && TextUtils.equals((CharSequence)this.zzeez, (CharSequence)credential.zzeez);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzbuz, this.mName, this.zzeew, this.zzeey, this.zzeem, this.zzeez});
    }

    public static class Builder {
        private final String zzbuz;
        private String mName;
        private Uri zzeew;
        private List<IdToken> zzeex;
        private String zzeey;
        private String zzeem;
        private String zzeez;
        private String zzefa;
        private String zzefb;
        private String zzefc;

        public Builder(String string) {
            this.zzbuz = string;
        }

        public Builder(Credential credential) {
            this.zzbuz = credential.zzbuz;
            this.mName = credential.mName;
            this.zzeew = credential.zzeew;
            this.zzeex = credential.zzeex;
            this.zzeey = credential.zzeey;
            this.zzeem = credential.zzeem;
            this.zzeez = credential.zzeez;
            this.zzefa = credential.zzefa;
            this.zzefb = credential.zzefb;
            this.zzefc = credential.zzefc;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zzeew = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.zzeey = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.zzeem = string;
            return this;
        }

        public Credential build() {
            return new Credential(this.zzbuz, this.mName, this.zzeew, this.zzeex, this.zzeey, this.zzeem, this.zzeez, this.zzefa, this.zzefb, this.zzefc);
        }
    }
}

