/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.android.gms.auth.api.credentials.CredentialRequest;
import com.google.android.gms.auth.api.credentials.CredentialRequestResponse;
import com.google.android.gms.auth.api.credentials.HintRequest;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Response;
import com.google.android.gms.common.api.internal.zzcz;
import com.google.android.gms.common.api.internal.zzg;
import com.google.android.gms.common.internal.zzbj;
import com.google.android.gms.internal.zzavx;
import com.google.android.gms.tasks.Task;

public class CredentialsClient
extends GoogleApi<Auth.AuthCredentialsOptions> {
    CredentialsClient(@NonNull Context context, @NonNull Auth.AuthCredentialsOptions authCredentialsOptions) {
        super(context, Auth.CREDENTIALS_API, (Api.ApiOptions)authCredentialsOptions, (zzcz)new zzg());
    }

    CredentialsClient(@NonNull Activity activity, @NonNull Auth.AuthCredentialsOptions authCredentialsOptions) {
        super(activity, Auth.CREDENTIALS_API, (Api.ApiOptions)authCredentialsOptions, (zzcz)new zzg());
    }

    public Task<CredentialRequestResponse> request(@NonNull CredentialRequest credentialRequest) {
        return zzbj.zza(Auth.CredentialsApi.request(this.zzago(), credentialRequest), (Response)new CredentialRequestResponse());
    }

    public PendingIntent getHintPickerIntent(@NonNull HintRequest hintRequest) {
        return zzavx.zza(this.getApplicationContext(), (Auth.AuthCredentialsOptions)this.zzagm(), hintRequest);
    }

    public Task<Void> save(@NonNull Credential credential) {
        return zzbj.zzb(Auth.CredentialsApi.save(this.zzago(), credential));
    }

    public Task<Void> delete(@NonNull Credential credential) {
        return zzbj.zzb(Auth.CredentialsApi.delete(this.zzago(), credential));
    }

    public Task<Void> disableAutoSignIn() {
        return zzbj.zzb(Auth.CredentialsApi.disableAutoSignIn(this.zzago()));
    }
}

