/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zzj;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

@Hide
public final class PasswordSpecification
extends zzbgl
implements ReflectedParcelable {
    public static final Parcelable.Creator<PasswordSpecification> CREATOR = new zzj();
    public static final PasswordSpecification zza = new zza().zza(12, 16).zza("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zza("abcdefghijkmnopqrstxyz", 1).zza("ABCDEFGHJKLMNPQRSTXY", 1).zza("3456789", 1).zza();
    private static PasswordSpecification zzb = new zza().zza(12, 16).zza("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zza("abcdefghijklmnopqrstuvwxyz", 1).zza("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zza("1234567890", 1).zza();
    @VisibleForTesting
    private String zzc;
    @VisibleForTesting
    private List<String> zzd;
    @VisibleForTesting
    private List<Integer> zze;
    @VisibleForTesting
    private int zzf;
    @VisibleForTesting
    private int zzg;
    private final int[] zzh;
    private final Random zzi;

    PasswordSpecification(String string, List<String> list, List<Integer> list2, int n, int n2) {
        this.zzc = string;
        this.zzd = Collections.unmodifiableList(list);
        this.zze = Collections.unmodifiableList(list2);
        this.zzf = n;
        this.zzg = n2;
        PasswordSpecification passwordSpecification = this;
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n3 = 0;
        Iterator<String> iterator = passwordSpecification.zzd.iterator();
        while (iterator.hasNext()) {
            for (char c : iterator.next().toCharArray()) {
                nArray[c - 32] = n3;
            }
            ++n3;
        }
        this.zzh = nArray;
        this.zzi = new SecureRandom();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PasswordSpecification passwordSpecification = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)passwordSpecification.zzc, (boolean)false);
        zzbgo.zzb((Parcel)parcel2, (int)2, passwordSpecification.zzd, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, passwordSpecification.zze, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (int)passwordSpecification.zzf);
        zzbgo.zza((Parcel)parcel2, (int)5, (int)passwordSpecification.zzg);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    private static String zzb(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzb(int n, int n2, int n3) {
        return n < 32 || n > 126;
    }

    public static final class zzb
    extends Error {
        public zzb(String string) {
            super(string);
        }
    }

    public static final class zza {
        private final TreeSet<Character> zza = new TreeSet();
        private final List<String> zzb = new ArrayList<String>();
        private final List<Integer> zzc = new ArrayList<Integer>();
        private int zzd = 12;
        private int zze = 16;

        public final zza zza(@NonNull String string) {
            this.zza.addAll(com.google.android.gms.auth.api.credentials.PasswordSpecification$zza.zza(string, "allowedChars"));
            return this;
        }

        public final zza zza(@NonNull String string, int n) {
            TreeSet<Character> treeSet = com.google.android.gms.auth.api.credentials.PasswordSpecification$zza.zza(string, "requiredChars");
            this.zzb.add(PasswordSpecification.zzb(treeSet));
            this.zzc.add(1);
            return this;
        }

        public final zza zza(int n, int n2) {
            this.zzd = 12;
            this.zze = 16;
            return this;
        }

        public final PasswordSpecification zza() {
            if (this.zza.isEmpty()) {
                throw new zzb("no allowed characters specified");
            }
            zza zza2 = this;
            int n = 0;
            Iterator<Object> iterator = zza2.zzc.iterator();
            while (iterator.hasNext()) {
                int n2 = iterator.next();
                n += n2;
            }
            if (n > zza2.zze) {
                throw new zzb("required character count cannot be greater than the max password size");
            }
            zza2 = this;
            boolean[] blArray = new boolean[95];
            iterator = zza2.zzb.iterator();
            while (iterator.hasNext()) {
                for (char c : ((String)iterator.next()).toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zzb(new StringBuilder(58).append("character ").append(c).append(" occurs in more than one required character set").toString());
                    }
                    blArray[c - 32] = true;
                }
            }
            return new PasswordSpecification(PasswordSpecification.zzb(this.zza), this.zzb, this.zzc, this.zzd, this.zze);
        }

        private static TreeSet<Character> zza(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new zzb(String.valueOf(string2).concat(" cannot be null or empty"));
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string.toCharArray()) {
                if (PasswordSpecification.zzb(c, 32, 126)) {
                    throw new zzb(String.valueOf(string2).concat(" must only contain ASCII printable characters"));
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }
    }
}

