/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.auth.api.credentials.zze;
import com.google.android.gms.auth.api.credentials.zzf;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SafeParcelable.Class(creator="CredentialPickerConfigCreator")
public final class CredentialPickerConfig
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<CredentialPickerConfig> CREATOR = new zzf();
    @SafeParcelable.Field(id=1000)
    private final int zzy;
    @SafeParcelable.Field(id=1, getter="shouldShowAddAccountButton")
    private final boolean zzcq;
    @SafeParcelable.Field(id=2, getter="shouldShowCancelButton")
    private final boolean mShowCancelButton;
    @Deprecated
    @SafeParcelable.Field(id=3, getter="isForNewAccount")
    private final boolean zzcr;
    @SafeParcelable.Field(id=4, getter="getPromptInternalId")
    private final int zzcs;

    @SafeParcelable.Constructor
    CredentialPickerConfig(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) boolean bl2, @SafeParcelable.Param(id=3) boolean bl3, @SafeParcelable.Param(id=4) int n2) {
        this.zzy = n;
        this.zzcq = bl;
        this.mShowCancelButton = bl2;
        if (n < 2) {
            this.zzcr = bl3;
            this.zzcs = bl3 ? 3 : 1;
            return;
        }
        this.zzcr = n2 == 3;
        this.zzcs = n2;
    }

    private CredentialPickerConfig(Builder builder) {
        this(2, builder.zzcq, builder.mShowCancelButton, false, builder.zzct);
    }

    public final boolean shouldShowAddAccountButton() {
        return this.zzcq;
    }

    public final boolean shouldShowCancelButton() {
        return this.mShowCancelButton;
    }

    @Deprecated
    public final boolean isForNewAccount() {
        return this.zzcs == 3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CredentialPickerConfig credentialPickerConfig = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)credentialPickerConfig.shouldShowAddAccountButton());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)credentialPickerConfig.shouldShowCancelButton());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)credentialPickerConfig.isForNewAccount());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)credentialPickerConfig.zzcs);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)credentialPickerConfig.zzy);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ CredentialPickerConfig(Builder builder, zze zze2) {
        this(builder);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Prompt {
        public static final int CONTINUE = 1;
        public static final int SIGN_IN = 2;
        public static final int SIGN_UP = 3;
    }

    public static class Builder {
        private boolean zzcq = false;
        private boolean mShowCancelButton = true;
        private int zzct = 1;

        public Builder() {
        }

        public Builder setShowAddAccountButton(boolean bl) {
            this.zzcq = bl;
            return this;
        }

        public Builder setShowCancelButton(boolean bl) {
            this.mShowCancelButton = bl;
            return this;
        }

        public Builder setPrompt(int n) {
            this.zzct = n;
            return this;
        }

        @Deprecated
        public Builder setForNewAccount(boolean bl) {
            this.zzct = bl ? 3 : 1;
            return this;
        }

        public CredentialPickerConfig build() {
            return new CredentialPickerConfig(this, null);
        }
    }
}

