/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzg;
import com.google.android.gms.auth.api.credentials.zzh;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@SafeParcelable.Class(creator="CredentialRequestCreator")
public final class CredentialRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CredentialRequest> CREATOR = new zzh();
    @SafeParcelable.Field(id=1000)
    private final int zzy;
    @SafeParcelable.Field(id=1, getter="isPasswordLoginSupported")
    private final boolean zzcu;
    @SafeParcelable.Field(id=2, getter="getAccountTypes")
    private final String[] zzcv;
    @SafeParcelable.Field(id=3, getter="getCredentialPickerConfig")
    private final CredentialPickerConfig zzcw;
    @SafeParcelable.Field(id=4, getter="getCredentialHintPickerConfig")
    private final CredentialPickerConfig zzcx;
    @SafeParcelable.Field(id=5, getter="isIdTokenRequested")
    private final boolean zzcy;
    @SafeParcelable.Field(id=6, getter="getServerClientId")
    private final String zzcz;
    @SafeParcelable.Field(id=7, getter="getIdTokenNonce")
    private final String zzda;
    @SafeParcelable.Field(id=8, getter="getRequireUserMediation")
    private final boolean zzdb;

    @SafeParcelable.Constructor
    CredentialRequest(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) String[] stringArray, @SafeParcelable.Param(id=3) CredentialPickerConfig credentialPickerConfig, @SafeParcelable.Param(id=4) CredentialPickerConfig credentialPickerConfig2, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) String string, @SafeParcelable.Param(id=7) String string2, @SafeParcelable.Param(id=8) boolean bl3) {
        this.zzy = n;
        this.zzcu = bl;
        this.zzcv = (String[])Preconditions.checkNotNull((Object)stringArray);
        this.zzcw = credentialPickerConfig == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig;
        CredentialPickerConfig credentialPickerConfig3 = this.zzcx = credentialPickerConfig2 == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig2;
        if (n < 3) {
            this.zzcy = true;
            this.zzcz = null;
            this.zzda = null;
        } else {
            this.zzcy = bl2;
            this.zzcz = string;
            this.zzda = string2;
        }
        this.zzdb = bl3;
    }

    private CredentialRequest(Builder builder) {
        this(4, builder.zzcu, builder.zzcv, builder.zzcw, builder.zzcx, builder.zzcy, builder.zzcz, builder.zzda, false);
    }

    @Deprecated
    public final boolean getSupportsPasswordLogin() {
        return this.isPasswordLoginSupported();
    }

    public final boolean isPasswordLoginSupported() {
        return this.zzcu;
    }

    @NonNull
    public final String[] getAccountTypes() {
        return this.zzcv;
    }

    @NonNull
    public final Set<String> getAccountTypesSet() {
        return new HashSet<String>(Arrays.asList(this.zzcv));
    }

    @NonNull
    public final CredentialPickerConfig getCredentialPickerConfig() {
        return this.zzcw;
    }

    @NonNull
    public final CredentialPickerConfig getCredentialHintPickerConfig() {
        return this.zzcx;
    }

    public final boolean isIdTokenRequested() {
        return this.zzcy;
    }

    @Nullable
    public final String getServerClientId() {
        return this.zzcz;
    }

    @Nullable
    public final String getIdTokenNonce() {
        return this.zzda;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CredentialRequest credentialRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)credentialRequest.isPasswordLoginSupported());
        SafeParcelWriter.writeStringArray((Parcel)parcel2, (int)2, (String[])credentialRequest.getAccountTypes(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)credentialRequest.getCredentialPickerConfig(), (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)credentialRequest.getCredentialHintPickerConfig(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)credentialRequest.isIdTokenRequested());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)credentialRequest.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)credentialRequest.getIdTokenNonce(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)credentialRequest.zzy);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)8, (boolean)credentialRequest.zzdb);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ CredentialRequest(Builder builder, zzg zzg2) {
        this(builder);
    }

    public static final class Builder {
        private boolean zzcu;
        private String[] zzcv;
        private CredentialPickerConfig zzcw;
        private CredentialPickerConfig zzcx;
        private boolean zzcy = false;
        private boolean zzdb = false;
        @Nullable
        private String zzcz = null;
        @Nullable
        private String zzda;

        public Builder() {
        }

        @Deprecated
        public final Builder setSupportsPasswordLogin(boolean bl) {
            return this.setPasswordLoginSupported(bl);
        }

        public final Builder setPasswordLoginSupported(boolean bl) {
            this.zzcu = bl;
            return this;
        }

        public final Builder setAccountTypes(String ... stringArray) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.zzcv = stringArray;
            return this;
        }

        public final Builder setCredentialPickerConfig(CredentialPickerConfig credentialPickerConfig) {
            this.zzcw = credentialPickerConfig;
            return this;
        }

        public final Builder setCredentialHintPickerConfig(CredentialPickerConfig credentialPickerConfig) {
            this.zzcx = credentialPickerConfig;
            return this;
        }

        public final Builder setIdTokenRequested(boolean bl) {
            this.zzcy = bl;
            return this;
        }

        public final Builder setServerClientId(@Nullable String string) {
            this.zzcz = string;
            return this;
        }

        public final Builder setIdTokenNonce(@Nullable String string) {
            this.zzda = string;
            return this;
        }

        public final CredentialRequest build() {
            if (this.zzcv == null) {
                this.zzcv = new String[0];
            }
            if (!this.zzcu && this.zzcv.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new CredentialRequest(this, null);
        }
    }
}

