/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzj;
import com.google.android.gms.auth.api.credentials.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="HintRequestCreator")
public final class HintRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<HintRequest> CREATOR = new zzk();
    @SafeParcelable.Field(id=1000)
    private final int zzy;
    @SafeParcelable.Field(id=1, getter="getHintPickerConfig")
    private final CredentialPickerConfig zzdc;
    @SafeParcelable.Field(id=2, getter="isEmailAddressIdentifierSupported")
    private final boolean zzdd;
    @SafeParcelable.Field(id=3, getter="isPhoneNumberIdentifierSupported")
    private final boolean zzde;
    @SafeParcelable.Field(id=4, getter="getAccountTypes")
    private final String[] zzcv;
    @SafeParcelable.Field(id=5, getter="isIdTokenRequested")
    private final boolean zzcy;
    @SafeParcelable.Field(id=6, getter="getServerClientId")
    private final String zzcz;
    @SafeParcelable.Field(id=7, getter="getIdTokenNonce")
    private final String zzda;

    @SafeParcelable.Constructor
    HintRequest(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) CredentialPickerConfig credentialPickerConfig, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) boolean bl2, @SafeParcelable.Param(id=4) String[] stringArray, @SafeParcelable.Param(id=5) boolean bl3, @SafeParcelable.Param(id=6) String string, @SafeParcelable.Param(id=7) String string2) {
        this.zzy = n;
        this.zzdc = (CredentialPickerConfig)((Object)Preconditions.checkNotNull((Object)((Object)credentialPickerConfig)));
        this.zzdd = bl;
        this.zzde = bl2;
        this.zzcv = (String[])Preconditions.checkNotNull((Object)stringArray);
        if (this.zzy < 2) {
            this.zzcy = true;
            this.zzcz = null;
            this.zzda = null;
            return;
        }
        this.zzcy = bl3;
        this.zzcz = string;
        this.zzda = string2;
    }

    private HintRequest(Builder builder) {
        this(2, builder.zzdc, builder.zzdd, builder.zzde, builder.zzcv, builder.zzcy, builder.zzcz, builder.zzda);
    }

    @NonNull
    public final CredentialPickerConfig getHintPickerConfig() {
        return this.zzdc;
    }

    public final boolean isEmailAddressIdentifierSupported() {
        return this.zzdd;
    }

    @NonNull
    public final String[] getAccountTypes() {
        return this.zzcv;
    }

    public final boolean isIdTokenRequested() {
        return this.zzcy;
    }

    @Nullable
    public final String getServerClientId() {
        return this.zzcz;
    }

    @Nullable
    public final String getIdTokenNonce() {
        return this.zzda;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        HintRequest hintRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)hintRequest.getHintPickerConfig(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)hintRequest.isEmailAddressIdentifierSupported());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)hintRequest.zzde);
        SafeParcelWriter.writeStringArray((Parcel)parcel2, (int)4, (String[])hintRequest.getAccountTypes(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)hintRequest.isIdTokenRequested());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)hintRequest.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)hintRequest.getIdTokenNonce(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)hintRequest.zzy);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ HintRequest(Builder builder, zzj zzj2) {
        this(builder);
    }

    public static final class Builder {
        private boolean zzdd;
        private boolean zzde;
        private String[] zzcv;
        private CredentialPickerConfig zzdc = new CredentialPickerConfig.Builder().build();
        private boolean zzcy = false;
        private String zzcz;
        private String zzda;

        public Builder() {
        }

        public final Builder setEmailAddressIdentifierSupported(boolean bl) {
            this.zzdd = bl;
            return this;
        }

        public final Builder setPhoneNumberIdentifierSupported(boolean bl) {
            this.zzde = bl;
            return this;
        }

        public final Builder setAccountTypes(String ... stringArray) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.zzcv = stringArray;
            return this;
        }

        public final Builder setHintPickerConfig(@NonNull CredentialPickerConfig credentialPickerConfig) {
            this.zzdc = (CredentialPickerConfig)((Object)Preconditions.checkNotNull((Object)((Object)credentialPickerConfig)));
            return this;
        }

        public final Builder setIdTokenRequested(boolean bl) {
            this.zzcy = bl;
            return this;
        }

        public final Builder setServerClientId(@Nullable String string) {
            this.zzcz = string;
            return this;
        }

        public final Builder setIdTokenNonce(@Nullable String string) {
            this.zzda = string;
            return this;
        }

        public final HintRequest build() {
            if (this.zzcv == null) {
                this.zzcv = new String[0];
            }
            if (!this.zzdd && !this.zzde && this.zzcv.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new HintRequest(this, null);
        }
    }
}

