/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zzm;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="PasswordSpecificationCreator")
public final class PasswordSpecification
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<PasswordSpecification> CREATOR = new zzm();
    public static final PasswordSpecification zzdg = new zzd().zzd(12, 16).zze("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zzd("abcdefghijkmnopqrstxyz", 1).zzd("ABCDEFGHJKLMNPQRSTXY", 1).zzd("3456789", 1).zzj();
    private static final PasswordSpecification zzdh = new zzd().zzd(12, 16).zze("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zzd("abcdefghijklmnopqrstuvwxyz", 1).zzd("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zzd("1234567890", 1).zzj();
    @SafeParcelable.Field(id=1)
    @VisibleForTesting
    private final String zzdi;
    @SafeParcelable.Field(id=2)
    @VisibleForTesting
    private final List<String> zzdj;
    @SafeParcelable.Field(id=3)
    @VisibleForTesting
    private final List<Integer> zzdk;
    @SafeParcelable.Field(id=4)
    @VisibleForTesting
    private final int zzdl;
    @SafeParcelable.Field(id=5)
    @VisibleForTesting
    private final int zzdm;
    private final int[] zzdn;
    private final Random zzdo;

    @SafeParcelable.Constructor
    PasswordSpecification(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) List<String> list, @SafeParcelable.Param(id=3) List<Integer> list2, @SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=5) int n2) {
        this.zzdi = string;
        this.zzdj = Collections.unmodifiableList(list);
        this.zzdk = Collections.unmodifiableList(list2);
        this.zzdl = n;
        this.zzdm = n2;
        PasswordSpecification passwordSpecification = this;
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n3 = 0;
        Iterator<String> iterator = passwordSpecification.zzdj.iterator();
        while (iterator.hasNext()) {
            for (char c : iterator.next().toCharArray()) {
                nArray[c - 32] = n3;
            }
            ++n3;
        }
        this.zzdn = nArray;
        this.zzdo = new SecureRandom();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PasswordSpecification passwordSpecification = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)passwordSpecification.zzdi, (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)2, passwordSpecification.zzdj, (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)3, passwordSpecification.zzdk, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)passwordSpecification.zzdl);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)5, (int)passwordSpecification.zzdm);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private static String zzd(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzd(int n, int n2, int n3) {
        return n < 32 || n > 126;
    }

    public static final class zze
    extends Error {
        public zze(String string) {
            super(string);
        }
    }

    public static final class zzd {
        private final TreeSet<Character> zzdp = new TreeSet();
        private final List<String> zzdj = new ArrayList<String>();
        private final List<Integer> zzdk = new ArrayList<Integer>();
        private int zzdl = 12;
        private int zzdm = 16;

        public final zzd zze(@NonNull String string) {
            this.zzdp.addAll(zzd.zzd(string, "allowedChars"));
            return this;
        }

        public final zzd zzd(@NonNull String string, int n) {
            TreeSet<Character> treeSet = zzd.zzd(string, "requiredChars");
            this.zzdj.add(PasswordSpecification.zzd(treeSet));
            this.zzdk.add(1);
            return this;
        }

        public final zzd zzd(int n, int n2) {
            this.zzdl = 12;
            this.zzdm = 16;
            return this;
        }

        public final PasswordSpecification zzj() {
            if (this.zzdp.isEmpty()) {
                throw new zze("no allowed characters specified");
            }
            zzd zzd2 = this;
            int n = 0;
            Iterator<Object> iterator = zzd2.zzdk.iterator();
            while (iterator.hasNext()) {
                int n2 = iterator.next();
                n += n2;
            }
            if (n > zzd2.zzdm) {
                throw new zze("required character count cannot be greater than the max password size");
            }
            zzd2 = this;
            boolean[] blArray = new boolean[95];
            iterator = zzd2.zzdj.iterator();
            while (iterator.hasNext()) {
                for (char c : ((String)iterator.next()).toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zze(new StringBuilder(58).append("character ").append(c).append(" occurs in more than one required character set").toString());
                    }
                    blArray[c - 32] = true;
                }
            }
            return new PasswordSpecification(PasswordSpecification.zzd(this.zzdp), this.zzdj, this.zzdk, this.zzdl, this.zzdm);
        }

        private static TreeSet<Character> zzd(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new zze(String.valueOf(string2).concat(" cannot be null or empty"));
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string.toCharArray()) {
                if (PasswordSpecification.zzd(c, 32, 126)) {
                    throw new zze(String.valueOf(string2).concat(" must only contain ASCII printable characters"));
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }
    }
}

