/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.Context;
import android.os.Binder;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.internal.Storage;
import com.google.android.gms.auth.api.signin.internal.zzp;
import com.google.android.gms.auth.api.signin.internal.zzr;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;

public final class zzw
extends zzr {
    private final Context mContext;

    public zzw(Context context) {
        this.mContext = context;
    }

    @Override
    public final void zzj() {
        this.zzl();
        zzw zzw2 = this;
        Storage storage = Storage.getInstance((Context)zzw2.mContext);
        GoogleSignInAccount googleSignInAccount = storage.getSavedDefaultGoogleSignInAccount();
        GoogleSignInOptions googleSignInOptions = GoogleSignInOptions.DEFAULT_SIGN_IN;
        if (googleSignInAccount != null) {
            googleSignInOptions = storage.getSavedDefaultGoogleSignInOptions();
        }
        GoogleApiClient googleApiClient = new GoogleApiClient.Builder(zzw2.mContext).addApi(Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions.HasOptions)googleSignInOptions).build();
        try {
            if (googleApiClient.blockingConnect().isSuccess()) {
                if (googleSignInAccount != null) {
                    Auth.GoogleSignInApi.revokeAccess(googleApiClient);
                } else {
                    googleApiClient.clearDefaultAccountAndReconnect();
                }
            }
            return;
        }
        finally {
            googleApiClient.disconnect();
        }
    }

    @Override
    public final void zzk() {
        this.zzl();
        zzp.zzd(this.mContext).clear();
    }

    private final void zzl() {
        if (!GooglePlayServicesUtil.isGooglePlayServicesUid((Context)this.mContext, (int)Binder.getCallingUid())) {
            int n = Binder.getCallingUid();
            throw new SecurityException(new StringBuilder(52).append("Calling UID ").append(n).append(" is not Google Play services.").toString());
        }
    }
}

