/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzf;
import com.google.android.gms.auth.api.credentials.zzg;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@SafeParcelable.Class(creator="CredentialRequestCreator")
public final class CredentialRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CredentialRequest> CREATOR = new zzg();
    @SafeParcelable.Field(id=1000)
    private final int zzv;
    @SafeParcelable.Field(id=1, getter="isPasswordLoginSupported")
    private final boolean zzaa;
    @SafeParcelable.Field(id=2, getter="getAccountTypes")
    private final String[] zzab;
    @SafeParcelable.Field(id=3, getter="getCredentialPickerConfig")
    private final CredentialPickerConfig zzac;
    @SafeParcelable.Field(id=4, getter="getCredentialHintPickerConfig")
    private final CredentialPickerConfig zzad;
    @SafeParcelable.Field(id=5, getter="isIdTokenRequested")
    private final boolean zzae;
    @SafeParcelable.Field(id=6, getter="getServerClientId")
    @Nullable
    private final String zzaf;
    @SafeParcelable.Field(id=7, getter="getIdTokenNonce")
    @Nullable
    private final String zzag;
    @SafeParcelable.Field(id=8, getter="getRequireUserMediation")
    private final boolean zzah;

    @SafeParcelable.Constructor
    CredentialRequest(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) String[] stringArray, @SafeParcelable.Param(id=3) @Nullable CredentialPickerConfig credentialPickerConfig, @SafeParcelable.Param(id=4) @Nullable CredentialPickerConfig credentialPickerConfig2, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) @Nullable String string, @SafeParcelable.Param(id=7) @Nullable String string2, @SafeParcelable.Param(id=8) boolean bl3) {
        this.zzv = n;
        this.zzaa = bl;
        this.zzab = (String[])Preconditions.checkNotNull((Object)stringArray);
        this.zzac = credentialPickerConfig == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig;
        CredentialPickerConfig credentialPickerConfig3 = this.zzad = credentialPickerConfig2 == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig2;
        if (n < 3) {
            this.zzae = true;
            this.zzaf = null;
            this.zzag = null;
        } else {
            this.zzae = bl2;
            this.zzaf = string;
            this.zzag = string2;
        }
        this.zzah = bl3;
    }

    private CredentialRequest(Builder builder) {
        this(4, builder.zzaa, builder.zzab, builder.zzac, builder.zzad, builder.zzae, builder.zzaf, builder.zzag, false);
    }

    @Deprecated
    public final boolean getSupportsPasswordLogin() {
        return this.isPasswordLoginSupported();
    }

    public final boolean isPasswordLoginSupported() {
        return this.zzaa;
    }

    @NonNull
    public final String[] getAccountTypes() {
        return this.zzab;
    }

    @NonNull
    public final Set<String> getAccountTypesSet() {
        return new HashSet<String>(Arrays.asList(this.zzab));
    }

    @NonNull
    public final CredentialPickerConfig getCredentialPickerConfig() {
        return this.zzac;
    }

    @NonNull
    public final CredentialPickerConfig getCredentialHintPickerConfig() {
        return this.zzad;
    }

    public final boolean isIdTokenRequested() {
        return this.zzae;
    }

    @Nullable
    public final String getServerClientId() {
        return this.zzaf;
    }

    @Nullable
    public final String getIdTokenNonce() {
        return this.zzag;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CredentialRequest credentialRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)credentialRequest.isPasswordLoginSupported());
        SafeParcelWriter.writeStringArray((Parcel)parcel2, (int)2, (String[])credentialRequest.getAccountTypes(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)credentialRequest.getCredentialPickerConfig(), (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)credentialRequest.getCredentialHintPickerConfig(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)credentialRequest.isIdTokenRequested());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)credentialRequest.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)credentialRequest.getIdTokenNonce(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)8, (boolean)credentialRequest.zzah);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)credentialRequest.zzv);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ CredentialRequest(Builder builder, zzf zzf2) {
        this(builder);
    }

    public static final class Builder {
        private boolean zzaa;
        private String[] zzab;
        private CredentialPickerConfig zzac;
        private CredentialPickerConfig zzad;
        private boolean zzae = false;
        private boolean zzah = false;
        @Nullable
        private String zzaf = null;
        @Nullable
        private String zzag;

        @Deprecated
        public final Builder setSupportsPasswordLogin(boolean bl) {
            return this.setPasswordLoginSupported(bl);
        }

        public final Builder setPasswordLoginSupported(boolean bl) {
            this.zzaa = bl;
            return this;
        }

        public final Builder setAccountTypes(String ... stringArray) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.zzab = stringArray;
            return this;
        }

        public final Builder setCredentialPickerConfig(CredentialPickerConfig credentialPickerConfig) {
            this.zzac = credentialPickerConfig;
            return this;
        }

        public final Builder setCredentialHintPickerConfig(CredentialPickerConfig credentialPickerConfig) {
            this.zzad = credentialPickerConfig;
            return this;
        }

        public final Builder setIdTokenRequested(boolean bl) {
            this.zzae = bl;
            return this;
        }

        public final Builder setServerClientId(@Nullable String string) {
            this.zzaf = string;
            return this;
        }

        public final Builder setIdTokenNonce(@Nullable String string) {
            this.zzag = string;
            return this;
        }

        public final CredentialRequest build() {
            if (this.zzab == null) {
                this.zzab = new String[0];
            }
            if (!this.zzaa && this.zzab.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new CredentialRequest(this, null);
        }
    }
}

