/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.credentials.zzk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="IdTokenCreator")
public final class IdToken
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<IdToken> CREATOR = new zzk();
    @NonNull
    @SafeParcelable.Field(id=1, getter="getAccountType")
    private final String zzr;
    @NonNull
    @SafeParcelable.Field(id=2, getter="getIdToken")
    private final String zzal;

    @SafeParcelable.Constructor
    public IdToken(@NonNull @SafeParcelable.Param(id=1) String string, @NonNull @SafeParcelable.Param(id=2) String string2) {
        Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"account type string cannot be null or empty");
        Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)string2) ? 1 : 0) != 0, (Object)"id token string cannot be null or empty");
        this.zzr = string;
        this.zzal = string2;
    }

    @NonNull
    public final String getAccountType() {
        return this.zzr;
    }

    @NonNull
    public final String getIdToken() {
        return this.zzal;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        IdToken idToken = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)idToken.getAccountType(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)idToken.getIdToken(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IdToken)) {
            return false;
        }
        IdToken idToken = (IdToken)((Object)object);
        return Objects.equal((Object)this.zzr, (Object)idToken.zzr) && Objects.equal((Object)this.zzal, (Object)idToken.zzal);
    }
}

