/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzf;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.auth.api.signin.internal.zzy;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.auth-api.zzan;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private static boolean zzco = false;
    private boolean zzcp = false;
    private SignInConfiguration zzcq;
    private boolean zzcr;
    private int zzcs;
    private Intent zzct;

    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        Intent intent = this.getIntent();
        String string = zzan.checkNotNull(intent.getAction());
        if ("com.google.android.gms.auth.NO_IMPL".equals(string)) {
            this.zzc(12500);
            return;
        }
        if (!string.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN") && !string.equals("com.google.android.gms.auth.APPAUTH_SIGN_IN")) {
            String string2 = String.valueOf(intent.getAction());
            Log.e((String)"AuthSignInClient", (String)(string2.length() != 0 ? "Unknown action: ".concat(string2) : new String("Unknown action: ")));
            this.finish();
            return;
        }
        SignInConfiguration signInConfiguration = (SignInConfiguration)zzan.checkNotNull(intent.getBundleExtra("config")).getParcelable("config");
        if (signInConfiguration == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        this.zzcq = signInConfiguration;
        if (bundle == null) {
            if (zzco) {
                this.setResult(0);
                this.zzc(12502);
                return;
            }
            zzco = true;
            String string3 = string;
            SignInHubActivity signInHubActivity = this;
            Intent intent2 = new Intent(string3);
            if (string3.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN")) {
                intent2.setPackage("com.google.android.gms");
            } else {
                intent2.setPackage(signInHubActivity.getPackageName());
            }
            intent2.putExtra("config", (Parcelable)signInHubActivity.zzcq);
            try {
                signInHubActivity.startActivityForResult(intent2, 40962);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                signInHubActivity.zzcp = true;
                Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
                signInHubActivity.zzc(17);
                return;
            }
        }
        this.zzcr = bundle.getBoolean("signingInGoogleApiClients");
        if (this.zzcr) {
            this.zzcs = bundle.getInt("signInResultCode");
            this.zzct = zzan.checkNotNull((Intent)bundle.getParcelable("signInResultData"));
            this.zzq();
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", this.zzcr);
        if (this.zzcr) {
            bundle.putInt("signInResultCode", this.zzcs);
            bundle.putParcelable("signInResultData", (Parcelable)this.zzct);
        }
    }

    protected void onActivityResult(int n, int n2, @Nullable Intent intent) {
        if (this.zzcp) {
            return;
        }
        this.setResult(0);
        switch (n) {
            case 40962: {
                Intent intent2 = intent;
                SignInHubActivity signInHubActivity = this;
                if (intent2 != null) {
                    SignInAccount signInAccount = (SignInAccount)intent2.getParcelableExtra("signInAccount");
                    if (signInAccount != null && signInAccount.getGoogleSignInAccount() != null) {
                        GoogleSignInAccount googleSignInAccount = signInAccount.getGoogleSignInAccount();
                        zzo.zzd((Context)signInHubActivity).zzc(signInHubActivity.zzcq.zzo(), zzan.checkNotNull(googleSignInAccount));
                        intent2.removeExtra("signInAccount");
                        intent2.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                        signInHubActivity.zzcr = true;
                        signInHubActivity.zzcs = n2;
                        signInHubActivity.zzct = intent2;
                        signInHubActivity.zzq();
                        return;
                    }
                    if (intent2.hasExtra("errorCode")) {
                        int n3 = intent2.getIntExtra("errorCode", 8);
                        if (n3 == 13) {
                            n3 = 12501;
                        }
                        signInHubActivity.zzc(n3);
                        return;
                    }
                }
                signInHubActivity.zzc(8);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return true;
    }

    private final void zzq() {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zzc(null));
        zzco = false;
    }

    private final void zzc(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
        zzco = false;
    }

    private final class zzc
    implements LoaderManager.LoaderCallbacks<Void> {
        private zzc() {
        }

        public final Loader<Void> onCreateLoader(int n, Bundle bundle) {
            return new zzf((Context)SignInHubActivity.this, GoogleApiClient.getAllClients());
        }

        public final void onLoaderReset(Loader<Void> loader) {
        }

        public final /* synthetic */ void onLoadFinished(Loader loader, Object object) {
            Void cfr_ignored_0 = (Void)object;
            zzc zzc2 = this;
            zzc2.SignInHubActivity.this.setResult(zzc2.SignInHubActivity.this.zzcs, zzc2.SignInHubActivity.this.zzct);
            zzc2.SignInHubActivity.this.finish();
        }

        /* synthetic */ zzc(zzy zzy2) {
            this();
        }
    }
}

