/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzi;
import com.google.android.gms.auth.api.credentials.zzj;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="HintRequestCreator")
public final class HintRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<HintRequest> CREATOR = new zzj();
    @SafeParcelable.Field(id=1000)
    private final int zzv;
    @SafeParcelable.Field(id=1, getter="getHintPickerConfig")
    private final CredentialPickerConfig zzai;
    @SafeParcelable.Field(id=2, getter="isEmailAddressIdentifierSupported")
    private final boolean zzaj;
    @SafeParcelable.Field(id=3, getter="isPhoneNumberIdentifierSupported")
    private final boolean zzak;
    @SafeParcelable.Field(id=4, getter="getAccountTypes")
    private final String[] zzab;
    @SafeParcelable.Field(id=5, getter="isIdTokenRequested")
    private final boolean zzae;
    @SafeParcelable.Field(id=6, getter="getServerClientId")
    @Nullable
    private final String zzaf;
    @SafeParcelable.Field(id=7, getter="getIdTokenNonce")
    @Nullable
    private final String zzag;

    @SafeParcelable.Constructor
    HintRequest(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) CredentialPickerConfig credentialPickerConfig, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) boolean bl2, @SafeParcelable.Param(id=4) String[] stringArray, @SafeParcelable.Param(id=5) boolean bl3, @SafeParcelable.Param(id=6) @Nullable String string, @SafeParcelable.Param(id=7) @Nullable String string2) {
        this.zzv = n;
        this.zzai = (CredentialPickerConfig)((Object)Preconditions.checkNotNull((Object)((Object)credentialPickerConfig)));
        this.zzaj = bl;
        this.zzak = bl2;
        this.zzab = (String[])Preconditions.checkNotNull((Object)stringArray);
        if (this.zzv < 2) {
            this.zzae = true;
            this.zzaf = null;
            this.zzag = null;
            return;
        }
        this.zzae = bl3;
        this.zzaf = string;
        this.zzag = string2;
    }

    private HintRequest(Builder builder) {
        this(2, builder.zzai, builder.zzaj, builder.zzak, builder.zzab, builder.zzae, builder.zzaf, builder.zzag);
    }

    @NonNull
    public final CredentialPickerConfig getHintPickerConfig() {
        return this.zzai;
    }

    public final boolean isEmailAddressIdentifierSupported() {
        return this.zzaj;
    }

    @NonNull
    public final String[] getAccountTypes() {
        return this.zzab;
    }

    public final boolean isIdTokenRequested() {
        return this.zzae;
    }

    @Nullable
    public final String getServerClientId() {
        return this.zzaf;
    }

    @Nullable
    public final String getIdTokenNonce() {
        return this.zzag;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        HintRequest hintRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)hintRequest.getHintPickerConfig(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)hintRequest.isEmailAddressIdentifierSupported());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)hintRequest.zzak);
        SafeParcelWriter.writeStringArray((Parcel)parcel2, (int)4, (String[])hintRequest.getAccountTypes(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)hintRequest.isIdTokenRequested());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)hintRequest.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)hintRequest.getIdTokenNonce(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)hintRequest.zzv);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ HintRequest(Builder builder, zzi zzi2) {
        this(builder);
    }

    public static final class Builder {
        private boolean zzaj;
        private boolean zzak;
        private String[] zzab;
        private CredentialPickerConfig zzai = new CredentialPickerConfig.Builder().build();
        private boolean zzae = false;
        @Nullable
        private String zzaf;
        @Nullable
        private String zzag;

        public final Builder setEmailAddressIdentifierSupported(boolean bl) {
            this.zzaj = bl;
            return this;
        }

        public final Builder setPhoneNumberIdentifierSupported(boolean bl) {
            this.zzak = bl;
            return this;
        }

        public final Builder setAccountTypes(String ... stringArray) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.zzab = stringArray;
            return this;
        }

        public final Builder setHintPickerConfig(@NonNull CredentialPickerConfig credentialPickerConfig) {
            this.zzai = (CredentialPickerConfig)((Object)Preconditions.checkNotNull((Object)((Object)credentialPickerConfig)));
            return this;
        }

        public final Builder setIdTokenRequested(boolean bl) {
            this.zzae = bl;
            return this;
        }

        public final Builder setServerClientId(@Nullable String string) {
            this.zzaf = string;
            return this;
        }

        public final Builder setIdTokenNonce(@Nullable String string) {
            this.zzag = string;
            return this;
        }

        public final HintRequest build() {
            if (this.zzab == null) {
                this.zzab = new String[0];
            }
            if (!this.zzaj && !this.zzak && this.zzab.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new HintRequest(this, null);
        }
    }
}

