/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzf;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.auth.api.signin.internal.zzy;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.auth-api.zzan;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private static boolean zzcr = false;
    private boolean zzcs = false;
    private SignInConfiguration zzct;
    private boolean zzcu;
    private int zzcv;
    private Intent zzcw;

    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        Intent intent = this.getIntent();
        String string = zzan.checkNotNull(intent.getAction());
        if ("com.google.android.gms.auth.NO_IMPL".equals(string)) {
            this.zzc(12500);
            return;
        }
        if (!string.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN") && !string.equals("com.google.android.gms.auth.APPAUTH_SIGN_IN")) {
            String string2 = String.valueOf(intent.getAction());
            Log.e((String)"AuthSignInClient", (String)(string2.length() != 0 ? "Unknown action: ".concat(string2) : new String("Unknown action: ")));
            this.finish();
            return;
        }
        SignInConfiguration signInConfiguration = (SignInConfiguration)zzan.checkNotNull(intent.getBundleExtra("config")).getParcelable("config");
        if (signInConfiguration == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        this.zzct = signInConfiguration;
        if (bundle == null) {
            if (zzcr) {
                this.setResult(0);
                this.zzc(12502);
                return;
            }
            zzcr = true;
            String string3 = string;
            SignInHubActivity signInHubActivity = this;
            Intent intent2 = new Intent(string3);
            if (string3.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN")) {
                intent2.setPackage("com.google.android.gms");
            } else {
                intent2.setPackage(signInHubActivity.getPackageName());
            }
            intent2.putExtra("config", (Parcelable)signInHubActivity.zzct);
            try {
                signInHubActivity.startActivityForResult(intent2, 40962);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                signInHubActivity.zzcs = true;
                Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
                signInHubActivity.zzc(17);
                return;
            }
        }
        this.zzcu = bundle.getBoolean("signingInGoogleApiClients");
        if (this.zzcu) {
            this.zzcv = bundle.getInt("signInResultCode");
            this.zzcw = zzan.checkNotNull((Intent)bundle.getParcelable("signInResultData"));
            this.zzr();
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", this.zzcu);
        if (this.zzcu) {
            bundle.putInt("signInResultCode", this.zzcv);
            bundle.putParcelable("signInResultData", (Parcelable)this.zzcw);
        }
    }

    protected void onActivityResult(int n, int n2, @Nullable Intent intent) {
        if (this.zzcs) {
            return;
        }
        this.setResult(0);
        switch (n) {
            case 40962: {
                Intent intent2 = intent;
                SignInHubActivity signInHubActivity = this;
                if (intent2 != null) {
                    SignInAccount signInAccount = (SignInAccount)intent2.getParcelableExtra("signInAccount");
                    if (signInAccount != null && signInAccount.getGoogleSignInAccount() != null) {
                        GoogleSignInAccount googleSignInAccount = signInAccount.getGoogleSignInAccount();
                        zzo.zzd((Context)signInHubActivity).zzc(signInHubActivity.zzct.zzp(), zzan.checkNotNull(googleSignInAccount));
                        intent2.removeExtra("signInAccount");
                        intent2.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                        signInHubActivity.zzcu = true;
                        signInHubActivity.zzcv = n2;
                        signInHubActivity.zzcw = intent2;
                        signInHubActivity.zzr();
                        return;
                    }
                    if (intent2.hasExtra("errorCode")) {
                        int n3 = intent2.getIntExtra("errorCode", 8);
                        if (n3 == 13) {
                            n3 = 12501;
                        }
                        signInHubActivity.zzc(n3);
                        return;
                    }
                }
                signInHubActivity.zzc(8);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return true;
    }

    private final void zzr() {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zzc(null));
        zzcr = false;
    }

    private final void zzc(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
        zzcr = false;
    }

    private final class zzc
    implements LoaderManager.LoaderCallbacks<Void> {
        private zzc() {
        }

        public final Loader<Void> onCreateLoader(int n, Bundle bundle) {
            return new zzf((Context)SignInHubActivity.this, GoogleApiClient.getAllClients());
        }

        public final void onLoaderReset(Loader<Void> loader) {
        }

        public final /* synthetic */ void onLoadFinished(Loader loader, Object object) {
            Void cfr_ignored_0 = (Void)object;
            zzc zzc2 = this;
            zzc2.SignInHubActivity.this.setResult(zzc2.SignInHubActivity.this.zzcv, zzc2.SignInHubActivity.this.zzcw);
            zzc2.SignInHubActivity.this.finish();
        }

        /* synthetic */ zzc(zzy zzy2) {
            this();
        }
    }
}

