/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.SignInHubActivity;
import com.google.android.gms.auth.api.signin.internal.Storage;
import com.google.android.gms.auth.api.signin.internal.zzc;
import com.google.android.gms.auth.api.signin.internal.zzj;
import com.google.android.gms.auth.api.signin.internal.zzl;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.PendingResults;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.OptionalPendingResultImpl;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import java.util.HashSet;
import java.util.Iterator;

public final class zzg {
    private static Logger zzcb = new Logger("GoogleSignInCommon", new String[0]);

    public static Intent zzc(Context context, GoogleSignInOptions googleSignInOptions) {
        zzcb.d("getSignInIntent()", new Object[0]);
        SignInConfiguration signInConfiguration = new SignInConfiguration(context.getPackageName(), googleSignInOptions);
        Intent intent = new Intent("com.google.android.gms.auth.GOOGLE_SIGN_IN");
        intent.setPackage(context.getPackageName());
        intent.setClass(context, SignInHubActivity.class);
        Bundle bundle = new Bundle();
        bundle.putParcelable("config", (Parcelable)signInConfiguration);
        intent.putExtra("config", bundle);
        return intent;
    }

    public static Intent zzd(Context context, GoogleSignInOptions googleSignInOptions) {
        zzcb.d("getFallbackSignInIntent()", new Object[0]);
        Intent intent = zzg.zzc(context, googleSignInOptions);
        intent.setAction("com.google.android.gms.auth.APPAUTH_SIGN_IN");
        return intent;
    }

    public static Intent zze(Context context, GoogleSignInOptions googleSignInOptions) {
        zzcb.d("getNoImplementationSignInIntent()", new Object[0]);
        Intent intent = zzg.zzc(context, googleSignInOptions);
        intent.setAction("com.google.android.gms.auth.NO_IMPL");
        return intent;
    }

    /*
     * Unable to fully structure code
     */
    public static OptionalPendingResult<GoogleSignInResult> zzc(GoogleApiClient var0, Context var1_1, GoogleSignInOptions var2_2, boolean var3_3) {
        zzg.zzcb.d("silentSignIn()", new Object[0]);
        var6_4 = var2_2;
        var5_5 = var1_1;
        zzg.zzcb.d("getEligibleSavedSignInResult()", new Object[0]);
        Preconditions.checkNotNull((Object)var6_4);
        var7_6 = zzo.zzd(var5_5).zzm();
        if (var7_6 == null) ** GOTO lbl-1000
        var12_7 = var6_4.getAccount();
        var11_8 = var7_6.getAccount();
        v0 = var11_8 == null ? var12_7 == null : var11_8.equals((Object)var12_7);
        if (v0 && !var6_4.isServerAuthCodeRequested() && (!var6_4.isIdTokenRequested() || var7_6.isIdTokenRequested() && Objects.equal((Object)var6_4.getServerClientId(), (Object)var7_6.getServerClientId())) && (var8_9 = new HashSet(var7_6.getScopes())).containsAll(var9_10 = new HashSet<E>(var6_4.getScopes())) && (var10_11 = zzo.zzd(var5_5).zzl()) != null && !var10_11.isExpired()) {
            v1 = new GoogleSignInResult(var10_11, Status.RESULT_SUCCESS);
        } else lbl-1000:
        // 2 sources

        {
            v1 = var4_12 = null;
        }
        if (v1 != null) {
            zzg.zzcb.d("Eligible saved sign in result found", new Object[0]);
            return PendingResults.immediatePendingResult(var4_12, (GoogleApiClient)var0);
        }
        if (var3_3) {
            return PendingResults.immediatePendingResult((Result)new GoogleSignInResult(null, new Status(4)), (GoogleApiClient)var0);
        }
        var7_6 = var2_2;
        var6_4 = var1_1;
        var5_5 = var0;
        zzg.zzcb.d("trySilentSignIn()", new Object[0]);
        var8_9 = var5_5.enqueue((BaseImplementation.ApiMethodImpl)new zzj((GoogleApiClient)var5_5, (Context)var6_4, var7_6));
        return new OptionalPendingResultImpl((PendingResult)var8_9);
    }

    public static PendingResult<Status> zzc(GoogleApiClient googleApiClient, Context context, boolean bl) {
        zzcb.d("Signing out", new Object[0]);
        zzg.zzc(context);
        if (bl) {
            return PendingResults.immediatePendingResult((Status)Status.RESULT_SUCCESS, (GoogleApiClient)googleApiClient);
        }
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzl(googleApiClient));
    }

    public static PendingResult<Status> zzd(GoogleApiClient googleApiClient, Context context, boolean bl) {
        zzcb.d("Revoking access", new Object[0]);
        String string = Storage.getInstance((Context)context).getSavedRefreshToken();
        zzg.zzc(context);
        if (bl) {
            return zzc.zzf(string);
        }
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzn(googleApiClient));
    }

    private static void zzc(Context context) {
        zzo.zzd(context).clear();
        Iterator iterator = GoogleApiClient.getAllClients().iterator();
        while (iterator.hasNext()) {
            ((GoogleApiClient)iterator.next()).maybeSignOut();
        }
        GoogleApiManager.reportSignOut();
    }

    @Nullable
    public static GoogleSignInResult getSignInResultFromIntent(@Nullable Intent intent) {
        if (intent == null) {
            return new GoogleSignInResult(null, Status.RESULT_INTERNAL_ERROR);
        }
        Status status = (Status)intent.getParcelableExtra("googleSignInStatus");
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)intent.getParcelableExtra("googleSignInAccount");
        if (googleSignInAccount == null) {
            return new GoogleSignInResult(null, status == null ? Status.RESULT_INTERNAL_ERROR : status);
        }
        return new GoogleSignInResult(googleSignInAccount, Status.RESULT_SUCCESS);
    }
}

