/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.zzi;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.tasks.Task;

public class GoogleSignInClient
extends GoogleApi<GoogleSignInOptions> {
    private static final zzd zzbv = new zzd(null);
    @VisibleForTesting
    private static int zzbw = zzc.zzbx;

    GoogleSignInClient(@NonNull Context context, GoogleSignInOptions googleSignInOptions) {
        super(context, Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions)googleSignInOptions, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    GoogleSignInClient(@NonNull Activity activity, GoogleSignInOptions googleSignInOptions) {
        super(activity, Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions)googleSignInOptions, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    private final synchronized int zzl() {
        if (zzbw == zzc.zzbx) {
            Context context = this.getApplicationContext();
            GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
            int n = googleApiAvailability.isGooglePlayServicesAvailable(context, 12451000);
            zzbw = n == 0 ? zzc.zzca : (googleApiAvailability.getErrorResolutionIntent(context, n, null) == null && DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.auth.api.fallback") != 0 ? zzc.zzbz : zzc.zzby);
        }
        return zzbw;
    }

    @NonNull
    public Intent getSignInIntent() {
        Context context = this.getApplicationContext();
        switch (com.google.android.gms.auth.api.signin.zzc.zzbu[this.zzl() - 1]) {
            case 1: {
                return zzi.zzd(context, (GoogleSignInOptions)this.getApiOptions());
            }
            case 2: {
                return zzi.zzc(context, (GoogleSignInOptions)this.getApiOptions());
            }
        }
        return zzi.zze(context, (GoogleSignInOptions)this.getApiOptions());
    }

    public Task<GoogleSignInAccount> silentSignIn() {
        return PendingResultUtil.toTask(zzi.zzc(this.asGoogleApiClient(), this.getApplicationContext(), (GoogleSignInOptions)this.getApiOptions(), this.zzl() == zzc.zzbz), (PendingResultUtil.ResultConverter)zzbv);
    }

    public Task<Void> signOut() {
        return PendingResultUtil.toVoidTask(zzi.zzc(this.asGoogleApiClient(), this.getApplicationContext(), this.zzl() == zzc.zzbz));
    }

    public Task<Void> revokeAccess() {
        return PendingResultUtil.toVoidTask(zzi.zzd(this.asGoogleApiClient(), this.getApplicationContext(), this.zzl() == zzc.zzbz));
    }

    private static final class zzd
    implements PendingResultUtil.ResultConverter<GoogleSignInResult, GoogleSignInAccount> {
        private zzd() {
        }

        @Nullable
        public final /* synthetic */ Object convert(Result result) {
            return ((GoogleSignInResult)result).getSignInAccount();
        }

        /* synthetic */ zzd(com.google.android.gms.auth.api.signin.zzc zzc2) {
            this();
        }
    }

    @VisibleForTesting
    static final class zzc {
        public static final /* enum */ int zzbx = 1;
        public static final /* enum */ int zzby = 2;
        public static final /* enum */ int zzbz = 3;
        public static final /* enum */ int zzca = 4;
        private static final /* synthetic */ int[] zzcb;

        public static int[] zzm() {
            return (int[])zzcb.clone();
        }

        static {
            zzcb = new int[]{zzbx, zzby, zzbz, zzca};
        }
    }
}

