/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.accounts.Account;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;

public final class IdentityProviders {
    @RecentlyNonNull
    public static final String FACEBOOK = "https://www.facebook.com";
    @RecentlyNonNull
    public static final String GOOGLE = "https://accounts.google.com";
    @RecentlyNonNull
    public static final String LINKEDIN = "https://www.linkedin.com";
    @RecentlyNonNull
    public static final String MICROSOFT = "https://login.live.com";
    @RecentlyNonNull
    public static final String PAYPAL = "https://www.paypal.com";
    @RecentlyNonNull
    public static final String TWITTER = "https://twitter.com";
    @RecentlyNonNull
    public static final String YAHOO = "https://login.yahoo.com";

    @RecentlyNullable
    public static final String getIdentityProviderForAccount(@RecentlyNonNull Account account) {
        Account account2;
        Preconditions.checkNotNull((Object)account, (Object)"account cannot be null");
        if ("com.google".equals(account2.type)) {
            return GOOGLE;
        }
        if ("com.facebook.auth.login".equals(account2.type)) {
            return FACEBOOK;
        }
        return null;
    }

    private IdentityProviders() {
    }
}

