/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.identity;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.auth.api.identity.zba;
import com.google.android.gms.auth.api.identity.zbe;
import com.google.android.gms.auth.api.identity.zbf;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Class(creator="BeginSignInRequestCreator")
public final class BeginSignInRequest
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<BeginSignInRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getPasswordRequestOptions")
    private final PasswordRequestOptions zba;
    @SafeParcelable.Field(id=2, getter="getGoogleIdTokenRequestOptions")
    private final GoogleIdTokenRequestOptions zbb;
    @SafeParcelable.Field(id=3, getter="getSessionId")
    @Nullable
    private final String zbc;
    @SafeParcelable.Field(id=4, getter="isAutoSelectEnabled")
    private final boolean zbd;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zba, this.zbb, this.zbc, this.zbd};
        return Objects.hashCode((Object[])objectArray);
    }

    @RecentlyNonNull
    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    @RecentlyNonNull
    public GoogleIdTokenRequestOptions getGoogleIdTokenRequestOptions() {
        return this.zbb;
    }

    @RecentlyNonNull
    public PasswordRequestOptions getPasswordRequestOptions() {
        return this.zba;
    }

    static {
        zba zba2;
        CREATOR = zba2 = new zba();
    }

    @SafeParcelable.Constructor
    BeginSignInRequest(@SafeParcelable.Param(id=1) PasswordRequestOptions passwordRequestOptions, @SafeParcelable.Param(id=2) GoogleIdTokenRequestOptions googleIdTokenRequestOptions, @SafeParcelable.Param(id=3) @Nullable String string, @SafeParcelable.Param(id=4) boolean bl) {
        this.zba = (PasswordRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)passwordRequestOptions)));
        this.zbb = (GoogleIdTokenRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)googleIdTokenRequestOptions)));
        this.zbc = string;
        this.zbd = bl;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)1, (Parcelable)this.getPasswordRequestOptions(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getGoogleIdTokenRequestOptions(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zbc, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.isAutoSelectEnabled());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        BeginSignInRequest beginSignInRequest;
        if (!(o instanceof BeginSignInRequest)) {
            return false;
        }
        beginSignInRequest = beginSignInRequest;
        return Objects.equal((Object)((Object)this.zba), (Object)((Object)beginSignInRequest.zba)) && Objects.equal((Object)((Object)this.zbb), (Object)((Object)beginSignInRequest.zbb)) && Objects.equal((Object)this.zbc, (Object)beginSignInRequest.zbc) && this.zbd == beginSignInRequest.zbd;
    }

    public boolean isAutoSelectEnabled() {
        return this.zbd;
    }

    @RecentlyNonNull
    public static Builder zba(@RecentlyNonNull BeginSignInRequest object) {
        Preconditions.checkNotNull((Object)object);
        Builder builder = BeginSignInRequest.builder();
        builder.setGoogleIdTokenRequestOptions(object.getGoogleIdTokenRequestOptions());
        builder.setPasswordRequestOptions(object.getPasswordRequestOptions());
        builder.setAutoSelectEnabled(object.zbd);
        object = object.zbc;
        if (object != null) {
            builder.zba((String)object);
        }
        return builder;
    }

    @SafeParcelable.Class(creator="GoogleIdTokenRequestOptionsCreator")
    public static final class GoogleIdTokenRequestOptions
    extends AbstractSafeParcelable {
        @RecentlyNonNull
        public static final Parcelable.Creator<GoogleIdTokenRequestOptions> CREATOR;
        @SafeParcelable.Field(id=1, getter="isSupported")
        private final boolean zba;
        @SafeParcelable.Field(id=2, getter="getServerClientId")
        @Nullable
        private final String zbb;
        @SafeParcelable.Field(id=3, getter="getNonce")
        @Nullable
        private final String zbc;
        @SafeParcelable.Field(id=4, getter="filterByAuthorizedAccounts")
        private final boolean zbd;
        @SafeParcelable.Field(id=5, getter="getLinkedServiceId")
        @Nullable
        private final String zbe;
        @SafeParcelable.Field(id=6, getter="getIdTokenDepositionScopes")
        @Nullable
        private final List<String> zbf;

        public int hashCode() {
            Object[] objectArray = new Object[]{this.zba, this.zbb, this.zbc, this.zbd, this.zbe, this.zbf};
            return Objects.hashCode((Object[])objectArray);
        }

        @RecentlyNonNull
        public static Builder builder() {
            Builder builder = new Builder();
            return builder;
        }

        @RecentlyNullable
        public String getLinkedServiceId() {
            return this.zbe;
        }

        @RecentlyNullable
        public String getNonce() {
            return this.zbc;
        }

        @RecentlyNullable
        public String getServerClientId() {
            return this.zbb;
        }

        @RecentlyNullable
        public List<String> getIdTokenDepositionScopes() {
            return this.zbf;
        }

        static {
            zbe zbe2;
            CREATOR = zbe2 = new zbe();
        }

        /*
         * Enabled aggressive block sorting
         */
        @SafeParcelable.Constructor
        GoogleIdTokenRequestOptions(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) @Nullable String string2, @SafeParcelable.Param(id=4) boolean bl2, @SafeParcelable.Param(id=5) @Nullable String string3, @SafeParcelable.Param(id=6) @Nullable List<String> list) {
            ArrayList<String> arrayList;
            this.zba = bl;
            if (bl) {
                Preconditions.checkNotNull((Object)string, (Object)"serverClientId must be provided if Google ID tokens are requested");
            }
            this.zbb = string;
            this.zbc = string2;
            this.zbd = bl2;
            if (list != null) {
                if (list.isEmpty()) {
                    arrayList = null;
                } else {
                    arrayList = new ArrayList<String>(list);
                    Collections.sort(arrayList);
                }
            } else {
                arrayList = null;
            }
            this.zbf = arrayList;
            this.zbe = string3;
        }

        /*
         * WARNING - void declaration
         */
        public void writeToParcel(@RecentlyNonNull Parcel dest, int n) {
            void var1_1;
            n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)1, (boolean)this.isSupported());
            SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getServerClientId(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getNonce(), (boolean)false);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.filterByAuthorizedAccounts());
            SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getLinkedServiceId(), (boolean)false);
            SafeParcelWriter.writeStringList((Parcel)var1_1, (int)6, this.getIdTokenDepositionScopes(), (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
        }

        public boolean equals(@Nullable Object o) {
            GoogleIdTokenRequestOptions googleIdTokenRequestOptions;
            if (!(o instanceof GoogleIdTokenRequestOptions)) {
                return false;
            }
            googleIdTokenRequestOptions = googleIdTokenRequestOptions;
            return this.zba == googleIdTokenRequestOptions.zba && Objects.equal((Object)this.zbb, (Object)googleIdTokenRequestOptions.zbb) && Objects.equal((Object)this.zbc, (Object)googleIdTokenRequestOptions.zbc) && this.zbd == googleIdTokenRequestOptions.zbd && Objects.equal((Object)this.zbe, (Object)googleIdTokenRequestOptions.zbe) && Objects.equal(this.zbf, googleIdTokenRequestOptions.zbf);
        }

        public boolean filterByAuthorizedAccounts() {
            return this.zbd;
        }

        public boolean isSupported() {
            return this.zba;
        }

        public static final class Builder {
            private boolean zba = false;
            @Nullable
            private String zbb = null;
            @Nullable
            private String zbc = null;
            private boolean zbd = true;
            @Nullable
            private String zbe = null;
            @Nullable
            private List<String> zbf = null;

            /*
             * WARNING - void declaration
             */
            @RecentlyNonNull
            public Builder associateLinkedAccounts(@RecentlyNonNull String linkedServiceId, @Nullable List<String> idTokenDepositionScopes) {
                void var2_2;
                void var1_1;
                this.zbe = (String)Preconditions.checkNotNull((Object)var1_1, (Object)"linkedServiceId must be provided if you want to associate linked accounts.");
                this.zbf = var2_2;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @RecentlyNonNull
            public Builder setFilterByAuthorizedAccounts(boolean filterByAuthorizedAccounts) {
                void var1_1;
                this.zbd = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @RecentlyNonNull
            public Builder setNonce(@Nullable String nonce) {
                void var1_1;
                this.zbc = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @RecentlyNonNull
            public Builder setServerClientId(@RecentlyNonNull String serverClientId) {
                void var1_1;
                this.zbb = Preconditions.checkNotEmpty((String)var1_1);
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @RecentlyNonNull
            public Builder setSupported(boolean supported) {
                void var1_1;
                this.zba = var1_1;
                return this;
            }

            @RecentlyNonNull
            public GoogleIdTokenRequestOptions build() {
                GoogleIdTokenRequestOptions googleIdTokenRequestOptions = new GoogleIdTokenRequestOptions(this.zba, this.zbb, this.zbc, this.zbd, this.zbe, this.zbf);
                return googleIdTokenRequestOptions;
            }
        }
    }

    @SafeParcelable.Class(creator="PasswordRequestOptionsCreator")
    public static final class PasswordRequestOptions
    extends AbstractSafeParcelable {
        @RecentlyNonNull
        public static final Parcelable.Creator<PasswordRequestOptions> CREATOR;
        @SafeParcelable.Field(id=1, getter="isSupported")
        private final boolean zba;

        public int hashCode() {
            Object[] objectArray = new Object[]{this.zba};
            return Objects.hashCode((Object[])objectArray);
        }

        @RecentlyNonNull
        public static Builder builder() {
            Builder builder = new Builder();
            return builder;
        }

        static {
            zbf zbf2;
            CREATOR = zbf2 = new zbf();
        }

        @SafeParcelable.Constructor
        PasswordRequestOptions(@SafeParcelable.Param(id=1) boolean bl) {
            this.zba = bl;
        }

        /*
         * WARNING - void declaration
         */
        public void writeToParcel(@RecentlyNonNull Parcel dest, int n) {
            void var1_1;
            n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)1, (boolean)this.isSupported());
            SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
        }

        public boolean equals(@Nullable Object o) {
            PasswordRequestOptions passwordRequestOptions;
            if (!(o instanceof PasswordRequestOptions)) {
                return false;
            }
            passwordRequestOptions = passwordRequestOptions;
            return this.zba == passwordRequestOptions.zba;
        }

        public boolean isSupported() {
            return this.zba;
        }

        public static final class Builder {
            private boolean zba = false;

            /*
             * WARNING - void declaration
             */
            @RecentlyNonNull
            public Builder setSupported(boolean supported) {
                void var1_1;
                this.zba = var1_1;
                return this;
            }

            @RecentlyNonNull
            public PasswordRequestOptions build() {
                PasswordRequestOptions passwordRequestOptions = new PasswordRequestOptions(this.zba);
                return passwordRequestOptions;
            }
        }
    }

    public static final class Builder {
        private PasswordRequestOptions zba;
        private GoogleIdTokenRequestOptions zbb;
        @Nullable
        private String zbc;
        private boolean zbd;

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setAutoSelectEnabled(boolean autoSelectEnabled) {
            void var1_1;
            this.zbd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setGoogleIdTokenRequestOptions(@RecentlyNonNull GoogleIdTokenRequestOptions googleIdTokenRequestOptions) {
            void var1_1;
            this.zbb = (GoogleIdTokenRequestOptions)((Object)Preconditions.checkNotNull((Object)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setPasswordRequestOptions(@RecentlyNonNull PasswordRequestOptions passwordRequestOptions) {
            void var1_1;
            this.zba = (PasswordRequestOptions)((Object)Preconditions.checkNotNull((Object)var1_1));
            return this;
        }

        @RecentlyNonNull
        public BeginSignInRequest build() {
            BeginSignInRequest beginSignInRequest = new BeginSignInRequest(this.zba, this.zbb, this.zbc, this.zbd);
            return beginSignInRequest;
        }

        public Builder() {
            Object object = PasswordRequestOptions.builder();
            ((PasswordRequestOptions.Builder)object).setSupported(false);
            this.zba = ((PasswordRequestOptions.Builder)object).build();
            object = GoogleIdTokenRequestOptions.builder();
            ((GoogleIdTokenRequestOptions.Builder)object).setSupported(false);
            this.zbb = ((GoogleIdTokenRequestOptions.Builder)object).build();
        }

        @RecentlyNonNull
        public final Builder zba(@RecentlyNonNull String string) {
            this.zbc = string;
            return this;
        }
    }
}

