/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.identity;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.auth.api.identity.zbd;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="GetSignInIntentRequestCreator")
public class GetSignInIntentRequest
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<GetSignInIntentRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getServerClientId")
    private final String zba;
    @SafeParcelable.Field(id=2, getter="getHostedDomainFilter")
    @Nullable
    private final String zbb;
    @SafeParcelable.Field(id=3, getter="getSessionId")
    @Nullable
    private String zbc;
    @SafeParcelable.Field(id=4, getter="getNonce")
    @Nullable
    private final String zbd;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zba, this.zbb};
        return Objects.hashCode((Object[])objectArray);
    }

    @RecentlyNonNull
    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    @RecentlyNullable
    public String getHostedDomainFilter() {
        return this.zbb;
    }

    @RecentlyNullable
    public String getNonce() {
        return this.zbd;
    }

    @RecentlyNonNull
    public String getServerClientId() {
        return this.zba;
    }

    static {
        zbd zbd2;
        CREATOR = zbd2 = new zbd();
    }

    @SafeParcelable.Constructor
    GetSignInIntentRequest(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable String string3, @SafeParcelable.Param(id=4) @Nullable String string4) {
        Preconditions.checkNotNull((Object)string);
        this.zba = string;
        this.zbb = string2;
        this.zbc = string3;
        this.zbd = string4;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel dest, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getHostedDomainFilter(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zbc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getNonce(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        GetSignInIntentRequest getSignInIntentRequest;
        if (!(o instanceof GetSignInIntentRequest)) {
            return false;
        }
        getSignInIntentRequest = getSignInIntentRequest;
        return Objects.equal((Object)this.zba, (Object)getSignInIntentRequest.zba) && Objects.equal((Object)this.zbd, (Object)getSignInIntentRequest.zbd) && Objects.equal((Object)this.zbb, (Object)getSignInIntentRequest.zbb);
    }

    @RecentlyNonNull
    public static Builder zba(@RecentlyNonNull GetSignInIntentRequest object) {
        Preconditions.checkNotNull((Object)object);
        Builder builder = GetSignInIntentRequest.builder();
        builder.setServerClientId(object.getServerClientId());
        builder.setNonce(object.getNonce());
        builder.filterByHostedDomain(object.getHostedDomainFilter());
        object = object.zbc;
        if (object != null) {
            builder.zba((String)object);
        }
        return builder;
    }

    public static final class Builder {
        private String zba;
        @Nullable
        private String zbb;
        @Nullable
        private String zbc;
        @Nullable
        private String zbd;

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder filterByHostedDomain(@Nullable String hostedDomainFilter) {
            void var1_1;
            this.zbb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setNonce(@Nullable String nonce) {
            void var1_1;
            this.zbd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setServerClientId(@RecentlyNonNull String serverClientId) {
            void var1_1;
            Preconditions.checkNotNull((Object)serverClientId);
            this.zba = var1_1;
            return this;
        }

        @RecentlyNonNull
        public GetSignInIntentRequest build() {
            GetSignInIntentRequest getSignInIntentRequest = new GetSignInIntentRequest(this.zba, this.zbb, this.zbc, this.zbd);
            return getSignInIntentRequest;
        }

        @RecentlyNonNull
        public final Builder zba(@Nullable String string) {
            this.zbc = string;
            return this;
        }
    }
}

