/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.fragment.app.Fragment;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.zbm;
import com.google.android.gms.auth.api.signin.internal.zbn;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ApiExceptionUtil;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class GoogleSignIn {
    /*
     * WARNING - void declaration
     */
    @NonNull
    public static GoogleSignInAccount getAccountForExtension(@RecentlyNonNull Context context, @RecentlyNonNull GoogleSignInOptionsExtension extension) {
        Context context2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"please provide a valid Context object");
        Preconditions.checkNotNull((Object)var1_1, (Object)"please provide valid GoogleSignInOptionsExtension");
        context2 = GoogleSignIn.getLastSignedInAccount(context2);
        if (context2 == null) {
            context2 = GoogleSignInAccount.createDefault();
        }
        return context2.requestExtraScopes(GoogleSignIn.zbb(var1_1.getImpliedScopes()));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static GoogleSignInAccount getAccountForScopes(@RecentlyNonNull Context context, @RecentlyNonNull Scope scope, Scope ... scopes) {
        void var2_2;
        Context context2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"please provide a valid Context object");
        Preconditions.checkNotNull((Object)var1_1, (Object)"please provide at least one valid scope");
        context2 = GoogleSignIn.getLastSignedInAccount(context2);
        if (context2 == null) {
            context2 = GoogleSignInAccount.createDefault();
        }
        Scope[] scopeArray = new Scope[]{var1_1};
        context2.requestExtraScopes(scopeArray);
        context2.requestExtraScopes((Scope[])var2_2);
        return context2;
    }

    @RecentlyNullable
    public static GoogleSignInAccount getLastSignedInAccount(@RecentlyNonNull Context context) {
        return zbn.zbc(context).zba();
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static GoogleSignInClient getClient(@RecentlyNonNull Activity activity, @RecentlyNonNull GoogleSignInOptions options) {
        void var1_1;
        Activity activity2;
        GoogleSignInClient googleSignInClient = new GoogleSignInClient(activity2, (GoogleSignInOptions)Preconditions.checkNotNull((Object)var1_1));
        return googleSignInClient;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static GoogleSignInClient getClient(@RecentlyNonNull Context context, @RecentlyNonNull GoogleSignInOptions options) {
        void var1_1;
        Context context2;
        GoogleSignInClient googleSignInClient = new GoogleSignInClient(context2, (GoogleSignInOptions)Preconditions.checkNotNull((Object)var1_1));
        return googleSignInClient;
    }

    @RecentlyNonNull
    public static Task<GoogleSignInAccount> getSignedInAccountFromIntent(@Nullable Intent data) {
        GoogleSignInResult googleSignInResult = zbm.zbd(data);
        GoogleSignInAccount googleSignInAccount = googleSignInResult.getSignInAccount();
        if (!googleSignInResult.getStatus().isSuccess() || googleSignInAccount == null) {
            return Tasks.forException((Exception)ApiExceptionUtil.fromStatus((Status)googleSignInResult.getStatus()));
        }
        return Tasks.forResult((Object)googleSignInAccount);
    }

    private GoogleSignIn() {
    }

    /*
     * WARNING - void declaration
     */
    public static void requestPermissions(@RecentlyNonNull Activity activity, int requestCode, @Nullable GoogleSignInAccount account, @RecentlyNonNull GoogleSignInOptionsExtension extension) {
        void var2_2;
        void var1_1;
        Activity activity2;
        void var3_3;
        Preconditions.checkNotNull((Object)activity, (Object)"Please provide a non-null Activity");
        Preconditions.checkNotNull((Object)var3_3, (Object)"Please provide a non-null GoogleSignInOptionsExtension");
        GoogleSignIn.requestPermissions(activity2, (int)var1_1, (GoogleSignInAccount)var2_2, GoogleSignIn.zbb(var3_3.getImpliedScopes()));
    }

    /*
     * WARNING - void declaration
     */
    public static void requestPermissions(@RecentlyNonNull Activity activity, int requestCode, @Nullable GoogleSignInAccount account, Scope ... scopes) {
        void var1_1;
        void var2_2;
        Activity activity2;
        void var3_3;
        Preconditions.checkNotNull((Object)activity, (Object)"Please provide a non-null Activity");
        Preconditions.checkNotNull((Object)var3_3, (Object)"Please provide at least one scope");
        activity2.startActivityForResult(GoogleSignIn.zba(activity2, (GoogleSignInAccount)var2_2, (Scope[])var3_3), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void requestPermissions(@RecentlyNonNull Fragment fragment, int requestCode, @Nullable GoogleSignInAccount account, @RecentlyNonNull GoogleSignInOptionsExtension extension) {
        void var2_2;
        void var1_1;
        Fragment fragment2;
        void var3_3;
        Preconditions.checkNotNull((Object)fragment, (Object)"Please provide a non-null Fragment");
        Preconditions.checkNotNull((Object)var3_3, (Object)"Please provide a non-null GoogleSignInOptionsExtension");
        GoogleSignIn.requestPermissions(fragment2, (int)var1_1, (GoogleSignInAccount)var2_2, GoogleSignIn.zbb(var3_3.getImpliedScopes()));
    }

    /*
     * WARNING - void declaration
     */
    public static void requestPermissions(@RecentlyNonNull Fragment fragment, int requestCode, @Nullable GoogleSignInAccount account, Scope ... scopes) {
        void var1_1;
        void var2_2;
        Fragment fragment2;
        void var3_3;
        Preconditions.checkNotNull((Object)fragment, (Object)"Please provide a non-null Fragment");
        Preconditions.checkNotNull((Object)var3_3, (Object)"Please provide at least one scope");
        fragment2.startActivityForResult(GoogleSignIn.zba((Activity)fragment2.getActivity(), (GoogleSignInAccount)var2_2, (Scope[])var3_3), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasPermissions(@Nullable GoogleSignInAccount account, @RecentlyNonNull GoogleSignInOptionsExtension extension) {
        void var1_1;
        GoogleSignInAccount googleSignInAccount;
        Preconditions.checkNotNull((Object)extension, (Object)"Please provide a non-null GoogleSignInOptionsExtension");
        return GoogleSignIn.hasPermissions(googleSignInAccount, GoogleSignIn.zbb(var1_1.getImpliedScopes()));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasPermissions(@Nullable GoogleSignInAccount account, Scope ... scopes) {
        GoogleSignInAccount googleSignInAccount;
        void var1_1;
        if (account == null) {
            return false;
        }
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, var1_1);
        return googleSignInAccount.getGrantedScopes().containsAll(hashSet);
    }

    @NonNull
    private static Intent zba(@NonNull Activity activity, @Nullable GoogleSignInAccount object, Scope ... scopeArray) {
        GoogleSignInOptions.Builder builder = new GoogleSignInOptions.Builder();
        if (scopeArray.length > 0) {
            builder.requestScopes(scopeArray[0], scopeArray);
        }
        if (object != null && !TextUtils.isEmpty((CharSequence)object.getEmail())) {
            builder.setAccountName((String)Preconditions.checkNotNull((Object)object.getEmail()));
        }
        object = new GoogleSignInClient(activity, builder.build());
        return ((GoogleSignInClient)((Object)object)).getSignInIntent();
    }

    @NonNull
    private static Scope[] zbb(@Nullable List<Scope> list) {
        if (list == null) {
            return new Scope[0];
        }
        return list.toArray(new Scope[list.size()]);
    }
}

