/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.auth-api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.BeginSignInRequest;
import com.google.android.gms.auth.api.identity.BeginSignInResult;
import com.google.android.gms.auth.api.identity.GetPhoneNumberHintIntentRequest;
import com.google.android.gms.auth.api.identity.GetSignInIntentRequest;
import com.google.android.gms.auth.api.identity.SignInClient;
import com.google.android.gms.auth.api.identity.SignInCredential;
import com.google.android.gms.auth.api.identity.zbo;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.IStatusCallback;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.internal.auth-api.zbai;
import com.google.android.gms.internal.auth-api.zbap;
import com.google.android.gms.internal.auth-api.zbaq;
import com.google.android.gms.internal.auth-api.zbar;
import com.google.android.gms.internal.auth-api.zbas;
import com.google.android.gms.internal.auth-api.zbat;
import com.google.android.gms.internal.auth-api.zbav;
import com.google.android.gms.internal.auth-api.zbax;
import com.google.android.gms.internal.auth-api.zbaz;
import com.google.android.gms.internal.auth-api.zbba;
import com.google.android.gms.internal.auth-api.zbbb;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Iterator;

public final class zbay
extends GoogleApi
implements SignInClient {
    private static final Api.ClientKey zba = new Api.ClientKey();
    private static final Api.AbstractClientBuilder zbb = new zbat();
    private static final Api zbc = new Api("Auth.Api.Identity.SignIn.API", zbb, zba);
    private final String zbd = zbbb.zba();

    @Override
    public final SignInCredential getSignInCredentialFromIntent(@Nullable Intent intent) throws ApiException {
        if (intent == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        Object object = (Status)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"status", (Parcelable.Creator)Status.CREATOR);
        if (object == null) {
            throw new ApiException(Status.RESULT_CANCELED);
        }
        if (!object.isSuccess()) {
            throw new ApiException((Status)object);
        }
        object = (SignInCredential)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"sign_in_credential", SignInCredential.CREATOR);
        if (object == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        return object;
    }

    @Override
    public final Task<BeginSignInResult> beginSignIn(@NonNull BeginSignInRequest beginSignInRequest) {
        Preconditions.checkNotNull((Object)((Object)beginSignInRequest));
        BeginSignInRequest.Builder builder = BeginSignInRequest.zba(beginSignInRequest);
        builder.zba(this.zbd);
        beginSignInRequest = builder.build();
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zbba.zba}).run((RemoteCall)new zbap(this, beginSignInRequest)).setAutoResolveMissingFeatures(false).setMethodKey(1553).build());
    }

    @Override
    public final Task<PendingIntent> getPhoneNumberHintIntent(@NonNull GetPhoneNumberHintIntentRequest getPhoneNumberHintIntentRequest) {
        Preconditions.checkNotNull((Object)((Object)getPhoneNumberHintIntentRequest));
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zbba.zbh}).run((RemoteCall)new zbas(this, getPhoneNumberHintIntentRequest)).setMethodKey(1653).build());
    }

    @Override
    public final Task<PendingIntent> getSignInIntent(@NonNull GetSignInIntentRequest getSignInIntentRequest) {
        Preconditions.checkNotNull((Object)((Object)getSignInIntentRequest));
        GetSignInIntentRequest.Builder builder = GetSignInIntentRequest.zba(getSignInIntentRequest);
        builder.zba(this.zbd);
        getSignInIntentRequest = builder.build();
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zbba.zbf}).run((RemoteCall)new zbaq(this, getSignInIntentRequest)).setMethodKey(1555).build());
    }

    @Override
    public final Task<Void> signOut() {
        this.getApplicationContext().getSharedPreferences("com.google.android.gms.signin", 0).edit().clear().apply();
        Iterator iterator = GoogleApiClient.getAllClients().iterator();
        while (iterator.hasNext()) {
            ((GoogleApiClient)iterator.next()).maybeSignOut();
        }
        GoogleApiManager.reportSignOut();
        return this.doWrite(TaskApiCall.builder().setFeatures(new Feature[]{zbba.zbb}).run((RemoteCall)new zbar(this)).setAutoResolveMissingFeatures(false).setMethodKey(1554).build());
    }

    @Override
    public final String getPhoneNumberFromIntent(@Nullable Intent intent) throws ApiException {
        if (intent == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        Object object = (Status)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"status", (Parcelable.Creator)Status.CREATOR);
        if (object == null) {
            throw new ApiException(Status.RESULT_CANCELED);
        }
        if (!object.isSuccess()) {
            throw new ApiException((Status)object);
        }
        object = intent.getStringExtra("phone_number_hint_result");
        if (object == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        return object;
    }

    public zbay(@NonNull Activity activity, @NonNull zbo zbo2) {
        super(activity, zbc, (Api.ApiOptions)zbo2, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zbay(@NonNull Context context, @NonNull zbo zbo2) {
        super(context, zbc, (Api.ApiOptions)zbo2, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    final /* synthetic */ void zba(GetPhoneNumberHintIntentRequest getPhoneNumberHintIntentRequest, zbaz zbaz2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zbax zbax2 = new zbax(this, taskCompletionSource);
        ((zbai)zbaz2.getService()).zbd(zbax2, getPhoneNumberHintIntentRequest, this.zbd);
    }

    final /* synthetic */ void zbb(zbaz zbaz2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zbav zbav2 = new zbav(this, taskCompletionSource);
        ((zbai)zbaz2.getService()).zbf((IStatusCallback)zbav2, this.zbd);
    }
}

