/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.loader.app.LoaderManager;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zbn;
import com.google.android.gms.auth.api.signin.internal.zbw;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.Status;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private static boolean zba = false;
    private boolean zbb = false;
    private SignInConfiguration zbc;
    private boolean zbd;
    private int zbe;
    private Intent zbf;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void onActivityResult(int n, int n2, @Nullable Intent intent) {
        if (this.zbb) {
            return;
        }
        this.setResult(0);
        switch (n) {
            default: {
                return;
            }
            case 40962: 
        }
        if (intent != null) {
            SignInAccount signInAccount = (SignInAccount)intent.getParcelableExtra("signInAccount");
            if (signInAccount != null && signInAccount.zba() != null) {
                if ((signInAccount = signInAccount.zba()) == null) {
                    Log.e((String)"AuthSignInClient", (String)"Google account is null");
                    this.zbd(12500);
                    return;
                }
                zbn.zbc((Context)this).zbe(this.zbc.zba(), (GoogleSignInAccount)signInAccount);
                intent.removeExtra("signInAccount");
                intent.putExtra("googleSignInAccount", (Parcelable)signInAccount);
                this.zbd = true;
                this.zbe = n2;
                this.zbf = intent;
                this.zbc();
                return;
            }
            if (intent.hasExtra("errorCode")) {
                int n3 = intent.getIntExtra("errorCode", 8);
                if (n3 == 13) {
                    n3 = 12501;
                }
                this.zbd(n3);
                return;
            }
        }
        this.zbd(8);
    }

    protected final void onCreate(@Nullable Bundle object) {
        super.onCreate(object);
        Object object2 = this.getIntent();
        String string = object2.getAction();
        if (string == null) {
            Log.e((String)"AuthSignInClient", (String)"Null action");
            this.zbd(12500);
            return;
        }
        if (string.equals("com.google.android.gms.auth.NO_IMPL")) {
            Log.e((String)"AuthSignInClient", (String)"Action not implemented");
            this.zbd(12500);
            return;
        }
        if (string.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN") || string.equals("com.google.android.gms.auth.APPAUTH_SIGN_IN")) {
            if ((object2 = object2.getBundleExtra("config")) == null) {
                Log.e((String)"AuthSignInClient", (String)"Activity started with no configuration.");
                this.setResult(0);
                this.finish();
                return;
            }
            if ((object2 = (SignInConfiguration)object2.getParcelable("config")) == null) {
                Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
                this.setResult(0);
                this.finish();
                return;
            }
            this.zbc = object2;
            if (object == null) {
                if (zba) {
                    this.setResult(0);
                    this.zbd(12502);
                    return;
                }
                zba = true;
                this.zbe(string);
                return;
            }
            this.zbd = object.getBoolean("signingInGoogleApiClients");
            if (this.zbd) {
                this.zbe = object.getInt("signInResultCode");
                if ((object = (Intent)object.getParcelable("signInResultData")) == null) {
                    Log.e((String)"AuthSignInClient", (String)"Sign in result data cannot be null");
                    this.setResult(0);
                    this.finish();
                    return;
                }
                this.zbf = object;
                this.zbc();
                return;
            }
            return;
        }
        object = String.valueOf(object2.getAction());
        object2 = "Unknown action: ";
        Log.e((String)"AuthSignInClient", (String)((String)object2).concat((String)object));
        this.finish();
    }

    public final void onDestroy() {
        super.onDestroy();
        zba = false;
    }

    protected final void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", signInHubActivity.zbd);
        if (signInHubActivity.zbd) {
            int n = signInHubActivity.zbe;
            bundle.putInt("signInResultCode", n);
            SignInHubActivity signInHubActivity = signInHubActivity.zbf;
            bundle.putParcelable("signInResultData", (Parcelable)signInHubActivity);
            return;
        }
    }

    public final boolean dispatchPopulateAccessibilityEvent(@NonNull AccessibilityEvent accessibilityEvent) {
        return true;
    }

    static /* bridge */ /* synthetic */ int zba(SignInHubActivity signInHubActivity) {
        return signInHubActivity.zbe;
    }

    static /* bridge */ /* synthetic */ Intent zbb(SignInHubActivity signInHubActivity) {
        return signInHubActivity.zbf;
    }

    private final void zbc() {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zbw(this, null));
        zba = false;
    }

    private final void zbd(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
        zba = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zbe(String object) {
        Intent intent = new Intent((String)object);
        if (((String)object).equals("com.google.android.gms.auth.GOOGLE_SIGN_IN")) {
            intent.setPackage("com.google.android.gms");
        } else {
            intent.setPackage(this.getPackageName());
        }
        SignInConfiguration signInConfiguration = this.zbc;
        intent.putExtra("config", (Parcelable)signInConfiguration);
        try {
            this.startActivityForResult(intent, 40962);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            this.zbb = true;
            Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
            this.zbd(17);
            return;
        }
    }
}

