/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.auth-api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.AuthorizationClient;
import com.google.android.gms.auth.api.identity.AuthorizationRequest;
import com.google.android.gms.auth.api.identity.AuthorizationResult;
import com.google.android.gms.auth.api.identity.zba;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.internal.auth-api.zbar;
import com.google.android.gms.internal.auth-api.zbas;
import com.google.android.gms.internal.auth-api.zbw;
import com.google.android.gms.internal.auth-api.zbx;
import com.google.android.gms.tasks.Task;

public final class zbz
extends GoogleApi
implements AuthorizationClient {
    private static final Api.ClientKey zba = new Api.ClientKey();
    private static final Api.AbstractClientBuilder zbb = new zbx();
    private static final Api zbc = new Api("Auth.Api.Identity.Authorization.API", zbb, zba);
    private final String zbd = zbas.zba();

    @Override
    public final AuthorizationResult getAuthorizationResultFromIntent(@Nullable Intent intent) throws ApiException {
        if (intent == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        Object object = (Status)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"status", (Parcelable.Creator)Status.CREATOR);
        if (object == null) {
            throw new ApiException(Status.RESULT_CANCELED);
        }
        if (!object.isSuccess()) {
            throw new ApiException((Status)object);
        }
        object = (AuthorizationResult)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"authorization_result", AuthorizationResult.CREATOR);
        if (object == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        return object;
    }

    @Override
    public final Task<AuthorizationResult> authorize(@NonNull AuthorizationRequest authorizationRequest) {
        Preconditions.checkNotNull((Object)((Object)authorizationRequest));
        AuthorizationRequest.Builder builder = AuthorizationRequest.zba(authorizationRequest);
        builder.zbb(this.zbd);
        authorizationRequest = builder.build();
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zbar.zbc}).run((RemoteCall)new zbw(this, authorizationRequest)).setAutoResolveMissingFeatures(false).setMethodKey(1534).build());
    }

    public zbz(@NonNull Activity activity, @NonNull zba zba2) {
        super(activity, zbc, (Api.ApiOptions)zba2, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zbz(@NonNull Context context, @NonNull zba zba2) {
        super(context, zbc, (Api.ApiOptions)zba2, GoogleApi.Settings.DEFAULT_SETTINGS);
    }
}

