/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzc;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;

public final class CredentialRequest
implements SafeParcelable {
    public static final Parcelable.Creator<CredentialRequest> CREATOR = new zzc();
    final int mVersionCode;
    private final boolean zzUG;
    private final String[] zzUH;
    private final CredentialPickerConfig zzUI;
    private final CredentialPickerConfig zzUJ;

    CredentialRequest(int version, boolean passwordLoginSupported, String[] accountTypes, CredentialPickerConfig credentialPickerConfig, CredentialPickerConfig credentialHintPickerConfig) {
        this.mVersionCode = version;
        this.zzUG = passwordLoginSupported;
        this.zzUH = (String[])zzx.zzy((Object)accountTypes);
        this.zzUI = credentialPickerConfig == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig;
        this.zzUJ = credentialHintPickerConfig == null ? new CredentialPickerConfig.Builder().build() : credentialHintPickerConfig;
    }

    private CredentialRequest(Builder builder) {
        this(2, builder.zzUG, builder.zzUH, builder.zzUI, builder.zzUJ);
    }

    @Deprecated
    public boolean getSupportsPasswordLogin() {
        return this.isPasswordLoginSupported();
    }

    public boolean isPasswordLoginSupported() {
        return this.zzUG;
    }

    public String[] getAccountTypes() {
        return this.zzUH;
    }

    public CredentialPickerConfig getCredentialPickerConfig() {
        return this.zzUI;
    }

    public CredentialPickerConfig getCredentialHintPickerConfig() {
        return this.zzUJ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    public static final class Builder {
        private boolean zzUG;
        private String[] zzUH;
        private CredentialPickerConfig zzUI;
        private CredentialPickerConfig zzUJ;

        @Deprecated
        public Builder setSupportsPasswordLogin(boolean supportsPasswordLogin) {
            return this.setPasswordLoginSupported(supportsPasswordLogin);
        }

        public Builder setPasswordLoginSupported(boolean passwordLoginSupported) {
            this.zzUG = passwordLoginSupported;
            return this;
        }

        public Builder setAccountTypes(String ... accountTypes) {
            if (accountTypes == null) {
                accountTypes = new String[]{};
            }
            this.zzUH = accountTypes;
            return this;
        }

        public Builder setCredentialPickerConfig(CredentialPickerConfig config) {
            this.zzUI = config;
            return this;
        }

        public Builder setCredentialHintPickerConfig(CredentialPickerConfig config) {
            this.zzUJ = config;
            return this;
        }

        public CredentialRequest build() {
            if (this.zzUH == null) {
                this.zzUH = new String[0];
            }
            if (!this.zzUG && this.zzUH.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new CredentialRequest(this);
        }
    }
}

