/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zzf;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public final class PasswordSpecification
implements SafeParcelable {
    public static final zzf CREATOR = new zzf();
    public static final PasswordSpecification zzUO = new zza().zzh(12, 16).zzbD("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zze("abcdefghijkmnopqrstxyz", 1).zze("ABCDEFGHJKLMNPQRSTXY", 1).zze("3456789", 1).zzmj();
    public static final PasswordSpecification zzUP = new zza().zzh(12, 16).zzbD("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zze("abcdefghijklmnopqrstuvwxyz", 1).zze("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zze("1234567890", 1).zzmj();
    final int mVersionCode;
    final String zzUQ;
    final List<String> zzUR;
    final List<Integer> zzUS;
    final int zzUT;
    final int zzUU;
    private final int[] zzUV;
    private final Random zzuj;

    PasswordSpecification(int version, String allowedChars, List<String> requiredCharSets, List<Integer> requiredCharCounts, int minimumSize, int maximumSize) {
        this.mVersionCode = version;
        this.zzUQ = allowedChars;
        this.zzUR = Collections.unmodifiableList(requiredCharSets);
        this.zzUS = Collections.unmodifiableList(requiredCharCounts);
        this.zzUT = minimumSize;
        this.zzUU = maximumSize;
        this.zzUV = this.zzmi();
        this.zzuj = new SecureRandom();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzf.zza(this, out, flags);
    }

    private int[] zzmi() {
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n = 0;
        for (String string : this.zzUR) {
            for (char c : string.toCharArray()) {
                nArray[this.zza((char)c)] = n;
            }
            ++n;
        }
        return nArray;
    }

    private int zza(char c) {
        return c - 32;
    }

    private static String zzb(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzb(int n, int n2, int n3) {
        return n < n2 || n > n3;
    }

    public static class zzb
    extends Error {
        public zzb(String string) {
            super(string);
        }
    }

    public static class zza {
        private final TreeSet<Character> zzUW = new TreeSet();
        private final List<String> zzUR = new ArrayList<String>();
        private final List<Integer> zzUS = new ArrayList<Integer>();
        private int zzUT = 12;
        private int zzUU = 16;

        public zza zzbD(String string) {
            this.zzUW.addAll(this.zzr(string, "allowedChars"));
            return this;
        }

        public zza zze(String string, int n) {
            if (n < 1) {
                throw new zzb("count must be at least 1");
            }
            TreeSet<Character> treeSet = this.zzr(string, "requiredChars");
            this.zzUR.add(PasswordSpecification.zzb(treeSet));
            this.zzUS.add(n);
            return this;
        }

        public zza zzh(int n, int n2) {
            if (n < 1) {
                throw new zzb("minimumSize must be at least 1");
            }
            if (n > n2) {
                throw new zzb("maximumSize must be greater than or equal to minimumSize");
            }
            this.zzUT = n;
            this.zzUU = n2;
            return this;
        }

        public PasswordSpecification zzmj() {
            if (this.zzUW.isEmpty()) {
                throw new zzb("no allowed characters specified");
            }
            this.zzmk();
            this.zzml();
            return new PasswordSpecification(1, PasswordSpecification.zzb(this.zzUW), this.zzUR, this.zzUS, this.zzUT, this.zzUU);
        }

        private TreeSet<Character> zzr(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new zzb(string2 + " cannot be null or empty");
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string.toCharArray()) {
                if (PasswordSpecification.zzb(c, 32, 126)) {
                    throw new zzb(string2 + " must only contain ASCII printable characters");
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }

        private void zzmk() {
            int n = 0;
            for (int n2 : this.zzUS) {
                n += n2;
            }
            if (n > this.zzUU) {
                throw new zzb("required character count cannot be greater than the max password size");
            }
        }

        private void zzml() {
            boolean[] blArray = new boolean[95];
            for (String string : this.zzUR) {
                for (char c : string.toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zzb("character " + c + " occurs in more than one required character set");
                    }
                    blArray[c - 32] = true;
                }
            }
        }
    }
}

