/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.text.TextUtils;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.IdpTokenType;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzb;
import com.google.android.gms.auth.api.signin.internal.zzh;
import com.google.android.gms.auth.api.signin.internal.zzj;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.auth.api.signin.zze;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzld;
import com.google.android.gms.internal.zzlf;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SignInHubActivity
extends FragmentActivity {
    private zzn zzWm;
    private zzj zzWn;
    private SignInConfiguration zzWo;
    private boolean zzWp;
    private String zzWq;
    private boolean zzWr;
    private int zzWs;
    private Intent zzWt;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.zzWm = zzn.zzae((Context)this);
        this.zzWo = (SignInConfiguration)this.getIntent().getParcelableExtra("config");
        this.zzWp = "com.google.android.gms.auth.GOOGLE_SIGN_IN".equals(this.getIntent().getAction());
        if (this.zzWo == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        LinkedList<zze> linkedList = new LinkedList<zze>();
        HashMap<zze, List<String>> hashMap = new HashMap<zze, List<String>>();
        zzh.zza(this.zzWo, linkedList, hashMap);
        this.zzWn = new zzj((Activity)this, linkedList, hashMap);
        zzlf zzlf2 = null;
        boolean bl = false;
        if (this.zzWo.zzmS() != null) {
            zzlf2 = (zzlf)this.zzWn.zza(zze.zzVK);
            zzlf2.zzaf((Context)this);
            if (this.zzWo.zzmQ() == null && this.zzWo.zzmR() == null) {
                bl = true;
            }
        }
        if (savedInstanceState == null) {
            Intent intent;
            if (this.zzWp) {
                intent = new Intent("com.google.android.gms.auth.GOOGLE_SIGN_IN");
            } else {
                intent = new Intent("com.google.android.gms.auth.LOGIN_PICKER");
                if ("com.google.android.gms.auth.RESOLVE_CREDENTIAL".equals(this.getIntent().getAction())) {
                    intent.fillIn(this.getIntent(), 3);
                } else {
                    this.zzWm.zzmY();
                    if (zzlf2 != null) {
                        try {
                            zzlf.zzag((Context)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (bl) {
                zzlf2.zza(this.zzmU());
                return;
            }
            this.zzj(intent);
        } else {
            this.zzWq = savedInstanceState.getString("pendingToken");
            this.zzWr = savedInstanceState.getBoolean("signingInGoogleApiClients");
            if (this.zzWr) {
                this.zzWs = savedInstanceState.getInt("signInResultCode");
                this.zzWt = (Intent)savedInstanceState.getParcelable("signInResultData");
                this.zzd(this.zzWs, this.zzWt);
            }
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("pendingToken", this.zzWq);
        outState.putBoolean("signingInGoogleApiClients", this.zzWr);
        if (this.zzWr) {
            outState.putInt("signInResultCode", this.zzWs);
            outState.putParcelable("signInResultData", (Parcelable)this.zzWt);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.setResult(0);
        switch (requestCode) {
            case 40962: {
                this.zza(resultCode, data);
                break;
            }
            case 40961: {
                this.zzb(resultCode, data);
                break;
            }
            case 45057: {
                this.zzc(resultCode, data);
                break;
            }
            default: {
                this.zza(requestCode, resultCode, data);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return true;
    }

    private void zza(int n, Intent intent) {
        if (intent != null) {
            SignInAccount signInAccount = (SignInAccount)intent.getParcelableExtra("signInAccount");
            if (signInAccount != null && signInAccount.zzmD() != null) {
                GoogleSignInAccount googleSignInAccount = signInAccount.zzmD();
                this.zzWm.zzb(googleSignInAccount, this.zzWo.zzmR());
                intent.removeExtra("signInAccount");
                intent.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                this.zzWr = true;
                this.zzWs = n;
                this.zzWt = intent;
                this.zzd(n, intent);
                return;
            }
            if (intent.hasExtra("errorCode")) {
                int n2 = intent.getIntExtra("errorCode", 8);
                this.zzaS(n2);
                return;
            }
        }
        this.zzaS(8);
    }

    private void zzb(int n, Intent intent) {
        if (n == -1) {
            SignInAccount signInAccount = (SignInAccount)intent.getParcelableExtra("signInAccount");
            if (signInAccount != null) {
                this.zzWm.zzb(signInAccount, this.zzWo);
                this.setResult(-1, intent);
                this.finish();
            } else {
                Log.w((String)"AuthSignInClient", (String)"[SignInHubActivity] SignInAccount is null.");
                this.zzaR(2);
            }
            return;
        }
        if (intent == null) {
            this.finish();
            return;
        }
        String string = intent.getStringExtra("email");
        zze zze2 = zze.zzbI((String)intent.getStringExtra("idProvider"));
        if (zze2 == null) {
            this.setResult(n, intent);
            this.finish();
            return;
        }
        this.zzWq = intent.getStringExtra("pendingToken");
        Intent intent2 = this.zzWo.zzmS().zzmt();
        if (zze.zzVK.equals((Object)zze2) && this.zzWo.zzmS() != null && intent2 != null) {
            this.startActivityForResult(intent2, 45057);
            return;
        }
        zzld zzld2 = this.zzWn.zza(zze2);
        if (zzld2 == null) {
            CharSequence charSequence = zze2.zzad((Context)this);
            Log.w((String)"AuthSignInClient", (String)(charSequence + " is not supported. Please check your configuration"));
            this.zzaR(1);
            return;
        }
        int n2 = intent.getIntExtra("userProfile", -1);
        if (n2 == 0) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                zzld2.zza(this.zzmU());
            } else {
                zzld2.zza(string, this.zzmU());
            }
        } else if (n2 == 1 && !TextUtils.isEmpty((CharSequence)this.zzWq) && !TextUtils.isEmpty((CharSequence)string)) {
            zzld2.zza(string, this.zzWq, this.zzmU());
        } else {
            Log.w((String)"AuthSignInClient", (String)"Internal error!");
            this.zzaR(2);
        }
    }

    private void zzc(int n, Intent intent) {
        if (n == 0) {
            this.setResult(0, intent);
            this.finish();
            return;
        }
        Intent intent2 = new Intent("com.google.android.gms.auth.VERIFY_ASSERTION");
        intent2.putExtra("idpTokenType", (Parcelable)IdpTokenType.zzWc);
        intent2.putExtra("idpToken", intent.getStringExtra("idpToken"));
        intent2.putExtra("pendingToken", this.zzWq);
        intent2.putExtra("idProvider", zze.zzVK.zzmC());
        this.zzj(intent2);
    }

    private void zza(int n, int n2, Intent intent) {
        for (zzld zzld2 : this.zzWn.zzmO()) {
            if (zzld2.zza(n, n2, intent, this.zzmU())) break;
        }
        if (n2 == 0) {
            this.finish();
        }
    }

    private void zzj(Intent intent) {
        intent.setPackage("com.google.android.gms");
        intent.putExtra("config", (Parcelable)this.zzWo);
        int n = this.zzWp ? 40962 : 40961;
        try {
            this.startActivityForResult(intent, n);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
            if (this.zzWp) {
                this.zzaS(8);
            }
            this.zzaR(2);
        }
    }

    private void zzd(int n, Intent intent) {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zza());
    }

    private void zzaR(int n) {
        Intent intent = new Intent();
        intent.putExtra("errorCode", n);
        this.setResult(0, intent);
        this.finish();
    }

    private void zzaS(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
    }

    private zzld.zza zzmU() {
        return new zzld.zza(){

            @Override
            public void zzk(Intent intent) {
                if (intent != null) {
                    SignInHubActivity.this.zzj(intent);
                } else {
                    Log.w((String)"AuthSignInClient", (String)"Idp signin failed!");
                    SignInHubActivity.this.zzaR(4);
                }
            }

            @Override
            public void zza(Exception exception) {
                String string = exception == null || exception.getMessage() == null ? "" : " " + exception.getMessage();
                Log.w((String)"AuthSignInClient", (String)("Idp signin failed!" + string));
                SignInHubActivity.this.zzaR(4);
            }

            @Override
            public void zzmV() {
                SignInHubActivity.this.setResult(0);
                SignInHubActivity.this.finish();
            }
        };
    }

    private class zza
    implements LoaderManager.LoaderCallbacks<Void> {
        private zza() {
        }

        public Loader<Void> onCreateLoader(int i, Bundle bundle) {
            return new zzb((Context)SignInHubActivity.this, GoogleApiClient.zzoE());
        }

        public void zza(Loader<Void> loader, Void void_) {
            SignInHubActivity.this.setResult(SignInHubActivity.this.zzWs, SignInHubActivity.this.zzWt);
            SignInHubActivity.this.finish();
        }

        public void onLoaderReset(Loader<Void> loader) {
        }

        public /* synthetic */ void onLoadFinished(Loader x0, Object x1) {
            this.zza((Loader<Void>)x0, (Void)x1);
        }
    }
}

