/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInApi;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.zzd;
import com.google.android.gms.auth.api.signin.internal.zzf;
import com.google.android.gms.auth.api.signin.internal.zzg;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.PendingResults;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzmo;
import java.util.HashSet;

public class zzc
implements GoogleSignInApi {
    @Override
    public Intent getSignInIntent(GoogleApiClient client) {
        zzx.zzy((Object)client);
        return ((zzd)client.zza(Auth.zzUa)).zzmK();
    }

    @Override
    public OptionalPendingResult<GoogleSignInResult> silentSignIn(GoogleApiClient client) {
        GoogleSignInOptions googleSignInOptions = this.zza(client);
        GoogleSignInResult googleSignInResult = this.zza(client.getContext(), googleSignInOptions);
        if (googleSignInResult != null) {
            return PendingResults.zzb((Result)googleSignInResult, (GoogleApiClient)client);
        }
        return this.zza(client, googleSignInOptions);
    }

    public GoogleSignInResult zza(Context context, GoogleSignInOptions googleSignInOptions) {
        HashSet hashSet;
        HashSet hashSet2;
        Log.d((String)"GoogleSignInApiImpl", (String)"getSavedSignInResultIfEligible");
        zzx.zzy((Object)googleSignInOptions);
        zzn zzn2 = zzn.zzae((Context)context);
        GoogleSignInOptions googleSignInOptions2 = zzn2.zzmX();
        if (googleSignInOptions2 == null) {
            return null;
        }
        if (!this.zza(googleSignInOptions2.getAccount(), googleSignInOptions.getAccount())) {
            return null;
        }
        if (googleSignInOptions.zzmz()) {
            return null;
        }
        if (googleSignInOptions.zzmy()) {
            if (!googleSignInOptions2.zzmy()) {
                return null;
            }
            if (!googleSignInOptions.zzmB().equals(googleSignInOptions2.zzmB())) {
                return null;
            }
        }
        if (!(hashSet2 = new HashSet(googleSignInOptions2.zzmu())).containsAll(hashSet = new HashSet(googleSignInOptions.zzmu()))) {
            return null;
        }
        GoogleSignInAccount googleSignInAccount = zzn2.zzmW();
        if (googleSignInAccount != null && !googleSignInAccount.zzb()) {
            return new GoogleSignInResult(googleSignInAccount, Status.zzaeX);
        }
        return null;
    }

    private boolean zza(Account account, Account account2) {
        if (account == null) {
            return account2 == null;
        }
        return account.equals((Object)account2);
    }

    private OptionalPendingResult<GoogleSignInResult> zza(final GoogleApiClient googleApiClient, final GoogleSignInOptions googleSignInOptions) {
        Log.d((String)"GoogleSignInApiImpl", (String)"trySilentSignIn");
        zzlx.zza zza2 = googleApiClient.zza((zzlx.zza)new zza<GoogleSignInResult>(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzg)zzd2.zzqs()).zza((zzf)new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zza(GoogleSignInAccount googleSignInAccount, Status status) throws RemoteException {
                        if (googleSignInAccount != null) {
                            zzn.zzae((Context)googleApiClient.getContext()).zzb(googleSignInAccount, googleSignInOptions);
                        }
                        this.zzb((Result)new GoogleSignInResult(googleSignInAccount, status));
                    }
                }, googleSignInOptions);
            }

            protected GoogleSignInResult zzn(Status status) {
                return new GoogleSignInResult(null, status);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzn(status);
            }
        });
        return new zzmo((PendingResult)zza2);
    }

    @Override
    public PendingResult<Status> signOut(final GoogleApiClient client) {
        zzn zzn2 = zzn.zzae((Context)client.getContext());
        zzn2.zzmZ();
        for (GoogleApiClient googleApiClient : GoogleApiClient.zzoE()) {
            googleApiClient.zzoF();
        }
        return client.zzb((zzlx.zza)new zza<Status>(client){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzg)zzd2.zzqs()).zzb((zzf)new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zzl(Status status) throws RemoteException {
                        this.zzb((Result)status);
                    }
                }, zzc.this.zza(client));
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> revokeAccess(final GoogleApiClient client) {
        zzn zzn2 = zzn.zzae((Context)client.getContext());
        zzn2.zzmZ();
        for (GoogleApiClient googleApiClient : GoogleApiClient.zzoE()) {
            googleApiClient.zzoF();
        }
        return client.zzb((zzlx.zza)new zza<Status>(client){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzg)zzd2.zzqs()).zzc(new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zzm(Status status) throws RemoteException {
                        this.zzb((Result)status);
                    }
                }, zzc.this.zza(client));
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public GoogleSignInResult getSignInResultFromIntent(Intent data) {
        if (data == null || !data.hasExtra("googleSignInStatus") && !data.hasExtra("googleSignInAccount")) {
            return null;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)data.getParcelableExtra("googleSignInAccount");
        Status status = (Status)data.getParcelableExtra("googleSignInStatus");
        if (googleSignInAccount != null) {
            status = Status.zzaeX;
        }
        return new GoogleSignInResult(googleSignInAccount, status);
    }

    private GoogleSignInOptions zza(GoogleApiClient googleApiClient) {
        return ((zzd)googleApiClient.zza(Auth.zzUa)).zzmL();
    }

    private abstract class zza<R extends Result>
    extends zzlx.zza<R, zzd> {
        public zza(GoogleApiClient googleApiClient) {
            super(Auth.zzUa, googleApiClient);
        }
    }
}

