/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzd;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;

public final class HintRequest
implements SafeParcelable {
    public static final Parcelable.Creator<HintRequest> CREATOR = new zzd();
    final int mVersionCode;
    private final CredentialPickerConfig zzWh;
    private final boolean zzWi;
    private final boolean zzWj;
    private final String[] zzWe;

    HintRequest(int version, CredentialPickerConfig hintPickerConfig, boolean emailAddressIdentifierSupported, boolean phoneNumberIdentifierSupported, String[] accountTypes) {
        this.mVersionCode = version;
        this.zzWh = (CredentialPickerConfig)zzx.zzz((Object)hintPickerConfig);
        this.zzWi = emailAddressIdentifierSupported;
        this.zzWj = phoneNumberIdentifierSupported;
        this.zzWe = (String[])zzx.zzz((Object)accountTypes);
    }

    private HintRequest(Builder builder) {
        this(1, builder.zzWh, builder.zzWi, builder.zzWj, builder.zzWe);
    }

    @NonNull
    public CredentialPickerConfig getHintPickerConfig() {
        return this.zzWh;
    }

    public boolean isEmailAddressIdentifierSupported() {
        return this.zzWi;
    }

    public boolean zzmy() {
        return this.zzWj;
    }

    @NonNull
    public String[] getAccountTypes() {
        return this.zzWe;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    public static final class Builder {
        private boolean zzWi;
        private boolean zzWj;
        private String[] zzWe;
        private CredentialPickerConfig zzWh = new CredentialPickerConfig.Builder().build();

        public Builder setEmailAddressIdentifierSupported(boolean emailAddressIdentifierSupported) {
            this.zzWi = emailAddressIdentifierSupported;
            return this;
        }

        public Builder setAccountTypes(String ... accountTypes) {
            if (accountTypes == null) {
                accountTypes = new String[]{};
            }
            this.zzWe = accountTypes;
            return this;
        }

        public Builder setHintPickerConfig(@NonNull CredentialPickerConfig hintPickerConfig) {
            this.zzWh = (CredentialPickerConfig)zzx.zzz((Object)hintPickerConfig);
            return this;
        }

        public HintRequest build() {
            if (this.zzWe == null) {
                this.zzWe = new String[0];
            }
            if (!this.zzWi && !this.zzWj && this.zzWe.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new HintRequest(this);
        }
    }
}

