/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.text.TextUtils;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.IdpTokenType;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzb;
import com.google.android.gms.auth.api.signin.internal.zzi;
import com.google.android.gms.auth.api.signin.internal.zzk;
import com.google.android.gms.auth.api.signin.internal.zzm;
import com.google.android.gms.auth.api.signin.internal.zzq;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzlf;
import com.google.android.gms.internal.zzlh;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private zzq zzXP;
    private zzk zzXQ;
    private SignInConfiguration zzXR;
    private boolean zzXS;
    private String zzXT;
    private String zzXU;
    private boolean zzXV;
    private int zzXW;
    private Intent zzXX;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.zzXP = zzq.zzaf((Context)this);
        Intent intent = this.getIntent();
        this.zzXR = (SignInConfiguration)intent.getParcelableExtra("config");
        this.zzXS = "com.google.android.gms.auth.GOOGLE_SIGN_IN".equals(intent.getAction());
        this.zzXU = intent.getStringExtra("scopes");
        if (this.zzXR == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        LinkedList<zzd> linkedList = new LinkedList<zzd>();
        HashMap<zzd, List<String>> hashMap = new HashMap<zzd, List<String>>();
        zzi.zza(this.zzXR, linkedList, hashMap);
        this.zzXQ = new zzk((Activity)this, linkedList, hashMap);
        zzlh zzlh2 = null;
        boolean bl = false;
        if (savedInstanceState == null) {
            Intent intent2;
            SignInAccount signInAccount = null;
            if (this.zzXS) {
                intent2 = new Intent("com.google.android.gms.auth.GOOGLE_SIGN_IN");
            } else {
                intent2 = new Intent("com.google.android.gms.auth.LOGIN_PICKER");
                if ("com.google.android.gms.auth.RESOLVE_CREDENTIAL".equals(intent.getAction())) {
                    intent2.fillIn(intent, 3);
                    signInAccount = (SignInAccount)intent.getParcelableExtra("signInAccount");
                } else {
                    this.zzXP.zznq();
                    if (zzlh2 != null) {
                        try {
                            zzlh.zzag((Context)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (bl || signInAccount != null && signInAccount.zzmU() == zzd.zzXi) {
                zzlh2.zza(this.zzbO(this.zzXU));
                return;
            }
            this.zzj(intent2);
        } else {
            this.zzXT = savedInstanceState.getString("pendingToken");
            this.zzXV = savedInstanceState.getBoolean("signingInGoogleApiClients");
            if (this.zzXV) {
                this.zzXW = savedInstanceState.getInt("signInResultCode");
                this.zzXX = (Intent)savedInstanceState.getParcelable("signInResultData");
                this.zzd(this.zzXW, this.zzXX);
            }
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("pendingToken", this.zzXT);
        outState.putBoolean("signingInGoogleApiClients", this.zzXV);
        if (this.zzXV) {
            outState.putInt("signInResultCode", this.zzXW);
            outState.putParcelable("signInResultData", (Parcelable)this.zzXX);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.setResult(0);
        switch (requestCode) {
            case 40962: {
                this.zza(resultCode, data);
                break;
            }
            case 40961: {
                this.zzb(resultCode, data);
                break;
            }
            case 45057: {
                this.zzc(resultCode, data);
                break;
            }
            default: {
                this.zza(requestCode, resultCode, data);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return true;
    }

    private void zza(int n, Intent intent) {
        if (intent != null) {
            SignInAccount signInAccount = (SignInAccount)intent.getParcelableExtra("signInAccount");
            if (signInAccount != null && signInAccount.zzmV() != null) {
                GoogleSignInAccount googleSignInAccount = signInAccount.zzmV();
                this.zzXP.zzb(googleSignInAccount, this.zzXR.zznm());
                intent.removeExtra("signInAccount");
                intent.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                this.zzXV = true;
                this.zzXW = n;
                this.zzXX = intent;
                this.zzd(n, intent);
                return;
            }
            if (intent.hasExtra("errorCode")) {
                int n2 = intent.getIntExtra("errorCode", 8);
                this.zzaS(n2);
                return;
            }
        }
        this.zzaS(8);
    }

    private void zzb(int n, Intent intent) {
        if (n == -1) {
            SignInAccount signInAccount = (SignInAccount)intent.getParcelableExtra("signInAccount");
            if (signInAccount != null) {
                this.zzXP.zzb(signInAccount, this.zzXR);
                String string = intent.getStringExtra("accessToken");
                if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)this.zzXU)) {
                    HashSet<String> hashSet = new HashSet<String>(Arrays.asList(TextUtils.split((String)this.zzXU, (String)" ")));
                    zzm zzm2 = zzm.zzbN(signInAccount.getUserId());
                    zzm2.zza(hashSet, new zzm.zza(string, intent.getLongExtra("accessTokenExpiresAtSecs", 0L)));
                    intent.removeExtra("accessTokenExpiresAtSecs");
                }
                this.setResult(-1, intent);
                this.finish();
            } else {
                Log.w((String)"AuthSignInClient", (String)"[SignInHubActivity] SignInAccount is null.");
                this.zzaR(2);
            }
            return;
        }
        if (intent == null) {
            this.finish();
            return;
        }
        String string = intent.getStringExtra("email");
        zzd zzd2 = zzd.zzbL((String)intent.getStringExtra("idProvider"));
        if (zzd2 == null) {
            this.setResult(n, intent);
            this.finish();
            return;
        }
        this.zzXT = intent.getStringExtra("pendingToken");
        zzlf zzlf2 = this.zzXQ.zza(zzd2);
        if (zzlf2 == null) {
            CharSequence charSequence = zzd2.zzae((Context)this);
            Log.w((String)"AuthSignInClient", (String)(charSequence + " is not supported. Please check your configuration"));
            this.zzaR(1);
            return;
        }
        int n2 = intent.getIntExtra("idpAction", -1);
        if (n2 == 0) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                zzlf2.zza(this.zzbO(this.zzXU));
            } else {
                zzlf2.zza(string, this.zzbO(this.zzXU));
            }
        } else if (n2 == 1 && !TextUtils.isEmpty((CharSequence)this.zzXT) && !TextUtils.isEmpty((CharSequence)string)) {
            zzlf2.zza(string, this.zzXT, this.zzbO(this.zzXU));
        } else {
            Log.w((String)"AuthSignInClient", (String)"Internal error!");
            this.zzaR(2);
        }
    }

    private void zzc(int n, Intent intent) {
        if (n == 0) {
            this.setResult(0, intent);
            this.finish();
            return;
        }
        Intent intent2 = new Intent("com.google.android.gms.auth.VERIFY_ASSERTION");
        intent2.putExtra("idpTokenType", (Parcelable)IdpTokenType.zzXA);
        intent2.putExtra("idpToken", intent.getStringExtra("idpToken"));
        intent2.putExtra("pendingToken", this.zzXT);
        intent2.putExtra("idProvider", zzd.zzXi.zzmT());
        this.zzj(intent2);
    }

    private void zza(int n, int n2, Intent intent) {
        for (zzlf zzlf2 : this.zzXQ.zznh()) {
            if (zzlf2.zza(n, n2, intent, this.zzbO(this.zzXU))) break;
        }
        if (n2 == 0) {
            this.finish();
        }
    }

    private void zzj(Intent intent) {
        intent.setPackage("com.google.android.gms");
        intent.putExtra("config", (Parcelable)this.zzXR);
        int n = this.zzXS ? 40962 : 40961;
        try {
            this.startActivityForResult(intent, n);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
            if (this.zzXS) {
                this.zzaS(8);
            }
            this.zzaR(2);
        }
    }

    private void zzd(int n, Intent intent) {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zza());
    }

    private void zzaR(int n) {
        Intent intent = new Intent();
        intent.putExtra("errorCode", n);
        this.setResult(0, intent);
        this.finish();
    }

    private void zzaS(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
    }

    private zzlf.zza zzbO(final String string) {
        return new zzlf.zza(){

            @Override
            public void zzk(Intent intent) {
                if (intent != null) {
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        intent.putExtra("scopes", string);
                    }
                    SignInHubActivity.this.zzj(intent);
                } else {
                    Log.w((String)"AuthSignInClient", (String)"Idp signin failed!");
                    SignInHubActivity.this.zzaR(4);
                }
            }
        };
    }

    private class zza
    implements LoaderManager.LoaderCallbacks<Void> {
        private zza() {
        }

        public Loader<Void> onCreateLoader(int i, Bundle bundle) {
            return new zzb((Context)SignInHubActivity.this, GoogleApiClient.zzoV());
        }

        public void zza(Loader<Void> loader, Void void_) {
            SignInHubActivity.this.setResult(SignInHubActivity.this.zzXW, SignInHubActivity.this.zzXX);
            SignInHubActivity.this.finish();
        }

        public void onLoaderReset(Loader<Void> loader) {
        }

        public /* synthetic */ void onLoadFinished(Loader loader, Object object) {
            this.zza((Loader<Void>)loader, (Void)object);
        }
    }
}

