/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.internal.zzb;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import java.util.Collections;
import java.util.List;

public class Credential
extends AbstractSafeParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    final int mVersionCode;
    private final String zzBc;
    @Nullable
    private final String mName;
    @Nullable
    private final Uri zzabv;
    private final List<IdToken> zzabw;
    @Nullable
    private final String zzabx;
    @Nullable
    private final String zzaby;
    @Nullable
    private final String zzabz;
    @Nullable
    private final String zzabA;

    Credential(int n, String string, String string2, Uri uri, List<IdToken> list, String string3, String string4, String string5, String string6) {
        this.mVersionCode = n;
        String string7 = ((String)zzaa.zzb((Object)string, (Object)"credential identifier cannot be null")).trim();
        zzaa.zzh((String)string7, (Object)"credential identifier cannot be empty");
        this.zzBc = string7;
        if (string2 != null && TextUtils.isEmpty((CharSequence)string2.trim())) {
            string2 = null;
        }
        this.mName = string2;
        this.zzabv = uri;
        this.zzabw = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.zzabx = string3;
        if (string3 != null && string3.isEmpty()) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            zzb.zzcl(string4);
        }
        this.zzaby = string4;
        this.zzabz = string5;
        this.zzabA = string6;
        if (!TextUtils.isEmpty((CharSequence)this.zzabx) && !TextUtils.isEmpty((CharSequence)this.zzaby)) {
            throw new IllegalStateException("password and accountType cannot both be set");
        }
    }

    public String getId() {
        return this.zzBc;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzabv;
    }

    public List<IdToken> getIdTokens() {
        return this.zzabw;
    }

    @Nullable
    public String getPassword() {
        return this.zzabx;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.zzabz;
    }

    @Nullable
    public String getAccountType() {
        return this.zzaby;
    }

    public String zzoW() {
        return this.zzabA;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.zzBc, (CharSequence)credential.zzBc) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzz.equal((Object)this.zzabv, (Object)credential.zzabv) && TextUtils.equals((CharSequence)this.zzabx, (CharSequence)credential.zzabx) && TextUtils.equals((CharSequence)this.zzaby, (CharSequence)credential.zzaby) && TextUtils.equals((CharSequence)this.zzabz, (CharSequence)credential.zzabz);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzBc, this.mName, this.zzabv, this.zzabx, this.zzaby, this.zzabz});
    }

    public static class Builder {
        private final String zzBc;
        private String mName;
        private Uri zzabv;
        private List<IdToken> zzabw;
        private String zzabx;
        private String zzaby;
        private String zzabz;
        private String zzabA;

        public Builder(String string) {
            this.zzBc = string;
        }

        public Builder(Credential credential) {
            this.zzBc = credential.zzBc;
            this.mName = credential.mName;
            this.zzabv = credential.zzabv;
            this.zzabw = credential.zzabw;
            this.zzabx = credential.zzabx;
            this.zzaby = credential.zzaby;
            this.zzabz = credential.zzabz;
            this.zzabA = credential.zzabA;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zzabv = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.zzabx = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.zzaby = string;
            return this;
        }

        public Credential build() {
            return new Credential(3, this.zzBc, this.mName, this.zzabv, this.zzabw, this.zzabx, this.zzaby, this.zzabz, this.zzabA);
        }
    }
}

