/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zzf;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public final class PasswordSpecification
extends AbstractSafeParcelable {
    public static final zzf CREATOR = new zzf();
    public static final PasswordSpecification zzabL = new zza().zzj(12, 16).zzck("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zze("abcdefghijkmnopqrstxyz", 1).zze("ABCDEFGHJKLMNPQRSTXY", 1).zze("3456789", 1).zzoZ();
    public static final PasswordSpecification zzabM = new zza().zzj(12, 16).zzck("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zze("abcdefghijklmnopqrstuvwxyz", 1).zze("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zze("1234567890", 1).zzoZ();
    final int mVersionCode;
    final String zzabN;
    final List<String> zzabO;
    final List<Integer> zzabP;
    final int zzabQ;
    final int zzabR;
    private final int[] zzabS;
    private final Random zzvQ;

    PasswordSpecification(int n, String string, List<String> list, List<Integer> list2, int n2, int n3) {
        this.mVersionCode = n;
        this.zzabN = string;
        this.zzabO = Collections.unmodifiableList(list);
        this.zzabP = Collections.unmodifiableList(list2);
        this.zzabQ = n2;
        this.zzabR = n3;
        this.zzabS = this.zzoY();
        this.zzvQ = new SecureRandom();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    private int[] zzoY() {
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n = 0;
        for (String string : this.zzabO) {
            for (char c : string.toCharArray()) {
                nArray[this.zza((char)c)] = n;
            }
            ++n;
        }
        return nArray;
    }

    private int zza(char c) {
        return c - 32;
    }

    private static String zzb(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzb(int n, int n2, int n3) {
        return n < n2 || n > n3;
    }

    public static class zzb
    extends Error {
        public zzb(String string) {
            super(string);
        }
    }

    public static class zza {
        private final TreeSet<Character> zzabT = new TreeSet();
        private final List<String> zzabO = new ArrayList<String>();
        private final List<Integer> zzabP = new ArrayList<Integer>();
        private int zzabQ = 12;
        private int zzabR = 16;

        public zza zzck(@NonNull String string) {
            this.zzabT.addAll(this.zzu(string, "allowedChars"));
            return this;
        }

        public zza zze(@NonNull String string, int n) {
            if (n < 1) {
                throw new zzb("count must be at least 1");
            }
            TreeSet<Character> treeSet = this.zzu(string, "requiredChars");
            this.zzabO.add(PasswordSpecification.zzb(treeSet));
            this.zzabP.add(n);
            return this;
        }

        public zza zzj(int n, int n2) {
            if (n < 1) {
                throw new zzb("minimumSize must be at least 1");
            }
            if (n > n2) {
                throw new zzb("maximumSize must be greater than or equal to minimumSize");
            }
            this.zzabQ = n;
            this.zzabR = n2;
            return this;
        }

        public PasswordSpecification zzoZ() {
            if (this.zzabT.isEmpty()) {
                throw new zzb("no allowed characters specified");
            }
            this.zzpa();
            this.zzpb();
            return new PasswordSpecification(1, PasswordSpecification.zzb(this.zzabT), this.zzabO, this.zzabP, this.zzabQ, this.zzabR);
        }

        private TreeSet<Character> zzu(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new zzb(String.valueOf(string2).concat(" cannot be null or empty"));
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string.toCharArray()) {
                if (PasswordSpecification.zzb(c, 32, 126)) {
                    throw new zzb(String.valueOf(string2).concat(" must only contain ASCII printable characters"));
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }

        private void zzpa() {
            int n = 0;
            for (int n2 : this.zzabP) {
                n += n2;
            }
            if (n > this.zzabR) {
                throw new zzb("required character count cannot be greater than the max password size");
            }
        }

        private void zzpb() {
            boolean[] blArray = new boolean[95];
            for (String string : this.zzabO) {
                for (char c : string.toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zzb(new StringBuilder(58).append("character ").append(c).append(" occurs in more than one required character set").toString());
                    }
                    blArray[c - 32] = true;
                }
            }
        }
    }
}

