/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.proxy;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Patterns;
import com.google.android.gms.auth.api.proxy.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProxyRequest
extends AbstractSafeParcelable {
    public static final int VERSION_CODE = 2;
    public static final Parcelable.Creator<ProxyRequest> CREATOR = new zzb();
    public static final int HTTP_METHOD_GET;
    public static final int HTTP_METHOD_POST;
    public static final int HTTP_METHOD_PUT;
    public static final int HTTP_METHOD_DELETE;
    public static final int HTTP_METHOD_HEAD;
    public static final int HTTP_METHOD_OPTIONS;
    public static final int HTTP_METHOD_TRACE;
    public static final int HTTP_METHOD_PATCH;
    public static final int LAST_CODE;
    final int versionCode;
    public final String url;
    public final int httpMethod;
    public final long timeoutMillis;
    public final byte[] body;
    Bundle zzacc;

    ProxyRequest(int n, String string, int n2, long l, byte[] byArray, Bundle bundle) {
        this.versionCode = n;
        this.url = string;
        this.httpMethod = n2;
        this.timeoutMillis = l;
        this.body = byArray;
        this.zzacc = bundle;
    }

    public Map<String, String> getHeaderMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.zzacc.size());
        for (String string : this.zzacc.keySet()) {
            linkedHashMap.put(string, this.zzacc.getString(string));
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public String toString() {
        String string = this.url;
        int n = this.httpMethod;
        return new StringBuilder(42 + String.valueOf(string).length()).append("ProxyRequest[ url: ").append(string).append(", method: ").append(n).append(" ]").toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    static {
        int n = 0;
        ++n;
        HTTP_METHOD_GET = 0;
        ++n;
        HTTP_METHOD_POST = 1;
        ++n;
        HTTP_METHOD_PUT = 2;
        ++n;
        HTTP_METHOD_DELETE = 3;
        ++n;
        HTTP_METHOD_HEAD = 4;
        ++n;
        HTTP_METHOD_OPTIONS = 5;
        ++n;
        HTTP_METHOD_TRACE = 6;
        ++n;
        HTTP_METHOD_PATCH = 7;
        LAST_CODE = 7;
    }

    public static class Builder {
        private String zzacd;
        private int zzace = HTTP_METHOD_GET;
        private long zzacf = 3000L;
        private byte[] zzacg = null;
        private Bundle zzach = new Bundle();

        public Builder(String string) {
            zzaa.zzdl((String)string);
            if (!Patterns.WEB_URL.matcher(string).matches()) {
                throw new IllegalArgumentException(new StringBuilder(51 + String.valueOf(string).length()).append("The supplied url [ ").append(string).append("] is not match Patterns.WEB_URL!").toString());
            }
            this.zzacd = string;
        }

        public Builder setHttpMethod(int n) {
            zzaa.zzb((n >= 0 && n <= LAST_CODE ? 1 : 0) != 0, (Object)"Unrecognized http method code.");
            this.zzace = n;
            return this;
        }

        public Builder setTimeoutMillis(long l) {
            zzaa.zzb((l >= 0L ? 1 : 0) != 0, (Object)"The specified timeout must be non-negative.");
            this.zzacf = l;
            return this;
        }

        public Builder putHeader(String string, String string2) {
            zzaa.zzh((String)string, (Object)"Header name cannot be null or empty!");
            this.zzach.putString(string, string2 == null ? "" : string2);
            return this;
        }

        public Builder setBody(byte[] byArray) {
            this.zzacg = byArray;
            return this;
        }

        public ProxyRequest build() {
            if (this.zzacg == null) {
                this.zzacg = new byte[0];
            }
            return new ProxyRequest(2, this.zzacd, this.zzace, this.zzacf, this.zzacg, this.zzach);
        }
    }
}

