/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.places.zzbi;
import com.google.android.gms.internal.places.zzbj;
import com.google.android.gms.internal.places.zzef;
import com.google.android.gms.internal.places.zzkt;
import com.google.android.gms.internal.places.zzku;
import com.google.android.gms.internal.places.zzn;

@SafeParcelable.Reserved(value={1})
@VisibleForTesting
@SafeParcelable.Class(creator="ContextDataCreator")
public final class zzbh
extends AbstractSafeParcelable {
    private static zzn zzbg = new zzbi();
    private static final int[] zzbh = new int[]{0, 1};
    public static final Parcelable.Creator<zzbh> CREATOR = new zzbj();
    @SafeParcelable.Field(id=2, getter="getContextProtoAsBytes", type="byte[]")
    private zzef zzbi = null;
    private byte[] zzbj;

    @SafeParcelable.Constructor
    public zzbh(@SafeParcelable.Param(id=2) byte[] byArray) {
        this.zzbj = (byte[])Preconditions.checkNotNull((Object)byArray);
        this.zzo();
    }

    private final void zzn() {
        if (!(this.zzbi != null)) {
            try {
                byte[] byArray = this.zzbj;
                this.zzbi = (zzef)zzku.zzb((zzku)new zzef(), (byte[])byArray);
                this.zzbj = null;
            }
            catch (zzkt zzkt2) {
                Log.e((String)"ContextData", (String)"Could not deserialize context bytes.", (Throwable)zzkt2);
                throw new IllegalStateException(zzkt2);
            }
        }
        this.zzo();
    }

    private final void zzo() {
        if (this.zzbi == null && this.zzbj != null) {
            return;
        }
        if (this.zzbi != null && this.zzbj == null) {
            return;
        }
        if (this.zzbi != null && this.zzbj != null) {
            throw new IllegalStateException("Invalid internal representation - full");
        }
        if (this.zzbi == null && this.zzbj == null) {
            throw new IllegalStateException("Invalid internal representation - empty");
        }
        throw new IllegalStateException("Impossible");
    }

    private final String getId() {
        this.zzn();
        return this.zzbi.zzkg;
    }

    public final int hashCode() {
        this.zzn();
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.zzbi.zzkh.version});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbh)) {
            return false;
        }
        zzbh zzbh2 = (zzbh)((Object)object);
        this.zzn();
        zzbh2.zzn();
        return this.getId().equals(zzbh2.getId()) && this.zzbi.zzkh.version == zzbh2.zzbi.zzkh.version;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzbh zzbh2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        zzbh zzbh3 = zzbh2;
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)2, (byte[])(zzbh3.zzbj != null ? zzbh3.zzbj : zzku.zzd((zzku)zzbh3.zzbi)), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        this.zzn();
        String string = String.valueOf(this.zzbi.toString());
        String string2 = String.valueOf(zzbg.zzb(this));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }
}

