/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.awareness.state.BeaconState;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.places.zzbe;
import com.google.android.gms.internal.places.zzee;
import com.google.android.gms.internal.places.zzkt;
import com.google.android.gms.internal.places.zzku;
import com.google.android.gms.internal.places.zzm;
import java.util.Arrays;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="TypeFilterImplCreator")
public final class zzt
extends BeaconState.TypeFilter {
    public static final Parcelable.Creator<zzt> CREATOR = new zzbe();
    @SafeParcelable.Field(id=2, getter="getTypeFilterAsBytes", type="byte[]")
    private final zzee zzx;

    @SafeParcelable.Constructor
    zzt(@SafeParcelable.Param(id=2) byte[] byArray) {
        zzee zzee2 = null;
        try {
            byte[] byArray2 = byArray;
            zzee2 = (zzee)zzku.zzb((zzku)new zzee(), (byte[])byArray2);
        }
        catch (zzkt zzkt2) {
            zzm.zzb("BeaconStateImpl", "Could not deserialize BeaconFence.BeaconTypeFilter");
        }
        this.zzx = zzee2;
    }

    public zzt(String string, String string2) {
        this.zzx = new zzee();
        this.zzx.namespace = Preconditions.checkNotEmpty((String)string);
        this.zzx.type = Preconditions.checkNotEmpty((String)string2);
    }

    public zzt(String string, String string2, byte[] byArray) {
        this.zzx = new zzee();
        this.zzx.namespace = Preconditions.checkNotEmpty((String)string);
        this.zzx.type = Preconditions.checkNotEmpty((String)string2);
        this.zzx.content = (byte[])Preconditions.checkNotNull((Object)byArray);
    }

    private final String getNamespace() {
        if (this.zzx == null) {
            return null;
        }
        return this.zzx.namespace;
    }

    private final String getType() {
        if (this.zzx == null) {
            return null;
        }
        return this.zzx.type;
    }

    private final byte[] getContent() {
        if (this.zzx == null || this.zzx.content == null || this.zzx.content.length == 0) {
            return null;
        }
        return this.zzx.content;
    }

    public final zzee zzg() {
        return this.zzx;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getNamespace(), this.getType(), this.getContent() == null ? 0 : Arrays.hashCode(this.getContent())});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzt)) {
            return false;
        }
        zzt zzt2 = (zzt)((Object)object);
        return TextUtils.equals((CharSequence)this.getNamespace(), (CharSequence)zzt2.getNamespace()) && TextUtils.equals((CharSequence)this.getType(), (CharSequence)zzt2.getType()) && Arrays.equals(this.getContent(), zzt2.getContent());
    }

    public final String toString() {
        String string = this.getNamespace();
        String string2 = this.getType();
        String string3 = this.getContent() == null ? "null" : new String(this.getContent());
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("(").append(string).append(",").append(string2).append(",").append(string3).append(")").toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzt zzt2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)2, (byte[])zzku.zzd((zzku)zzt2.zzx), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

