/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.awareness.state.Weather;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.contextmanager.zzbi;
import com.google.android.gms.internal.contextmanager.zzk;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="WeatherImplCreator")
public final class zzbj
extends AbstractSafeParcelable
implements Weather {
    public static final Parcelable.Creator<zzbj> CREATOR = new zzbi();
    @SafeParcelable.Field(id=2, getter="getTemperatureFahrenheit")
    private final float zzbp;
    @SafeParcelable.Field(id=3, getter="getFeelsLikeTemperatureFahrenheit")
    private final float zzbq;
    @SafeParcelable.Field(id=4, getter="getDewPointFahrenheit")
    private final float zzbr;
    @SafeParcelable.Field(id=5, getter="getHumidity")
    private final int zzbs;
    @SafeParcelable.Field(id=6, getter="getConditions")
    private final int[] zzbt;

    @SafeParcelable.Constructor
    public zzbj(@SafeParcelable.Param(id=2) float f, @SafeParcelable.Param(id=3) float f2, @SafeParcelable.Param(id=4) float f3, @SafeParcelable.Param(id=5) int n, @SafeParcelable.Param(id=6) int[] nArray) {
        this.zzbp = f;
        this.zzbq = f2;
        this.zzbr = f3;
        this.zzbs = n;
        this.zzbt = nArray;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzbj zzbj2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)2, (float)zzbj2.zzbp);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)3, (float)zzbj2.zzbq);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)4, (float)zzbj2.zzbr);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)5, (int)zzbj2.getHumidity());
        SafeParcelWriter.writeIntArray((Parcel)parcel2, (int)6, (int[])zzbj2.getConditions(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Override
    public final float getDewPoint(int n) {
        return zzbj.zza(n, this.zzbr);
    }

    @Override
    public final float getFeelsLikeTemperature(int n) {
        return zzbj.zza(n, this.zzbq);
    }

    @Override
    public final float getTemperature(int n) {
        return zzbj.zza(n, this.zzbp);
    }

    @Override
    public final int getHumidity() {
        return this.zzbs;
    }

    @Override
    public final int[] getConditions() {
        return this.zzbt;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Temp=").append(this.getTemperature(1)).append("F/").append(this.getTemperature(2)).append("C, Feels=").append(this.getFeelsLikeTemperature(1)).append("F/").append(this.getFeelsLikeTemperature(2)).append("C, Dew=").append(this.getDewPoint(1)).append("F/").append(this.getDewPoint(2)).append("C, Humidity=").append(this.getHumidity()).append(", Condition=");
        if (this.getConditions() == null) {
            stringBuilder.append("unknown");
        } else {
            stringBuilder.append("[");
            boolean bl = true;
            for (int n : this.getConditions()) {
                if (!bl) {
                    stringBuilder.append(",");
                }
                bl = false;
                stringBuilder.append(n);
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static float zza(int n, float f) {
        switch (n) {
            case 1: {
                return f;
            }
            case 2: {
                float f2 = f;
                return 5.0f * (f2 - 32.0f) / 9.0f;
            }
        }
        zzk.zza("WeatherImpl", "Invalid temperature unit %s", (Object)n);
        throw new IllegalArgumentException("Invalid temperature unit");
    }
}

