/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.contextmanager.zzbk;
import com.google.android.gms.internal.contextmanager.zzeb;
import com.google.android.gms.internal.contextmanager.zzkm;
import com.google.android.gms.internal.contextmanager.zzll;
import com.google.android.gms.internal.contextmanager.zzn;

@SafeParcelable.Reserved(value={1})
@ShowFirstParty
@VisibleForTesting
@SafeParcelable.Class(creator="ContextDataCreator")
public final class zzbl
extends AbstractSafeParcelable {
    private static zzn zzbu = null;
    private static final int[] zzbv = new int[]{0, 1};
    public static final Parcelable.Creator<zzbl> CREATOR = new zzbk();
    @SafeParcelable.Field(id=2, getter="getContextProtoAsBytes", type="byte[]")
    private zzeb zzbw = null;
    private byte[] zzbx;

    @SafeParcelable.Constructor
    public zzbl(@SafeParcelable.Param(id=2) byte[] byArray) {
        this.zzbx = (byte[])Preconditions.checkNotNull((Object)byArray);
        zzbl zzbl2 = this;
        if (!(zzbl2.zzbw == null && zzbl2.zzbx != null || zzbl2.zzbw != null && zzbl2.zzbx == null)) {
            if (zzbl2.zzbw != null && zzbl2.zzbx != null) {
                throw new IllegalStateException("Invalid internal representation - full");
            }
            if (zzbl2.zzbw == null && zzbl2.zzbx == null) {
                throw new IllegalStateException("Invalid internal representation - empty");
            }
            throw new IllegalStateException("Impossible");
        }
    }

    private final void zzm() {
        if (!(this.zzbw != null)) {
            byte[] byArray = this.zzbx;
            if (this.zzbx == null) {
                return;
            }
            try {
                this.zzbw = zzeb.zzb(byArray, zzkm.zzcx());
                this.zzbx = null;
                return;
            }
            catch (zzll zzll2) {
                Log.e((String)"ContextData", (String)"Could not deserialize context bytes.", (Throwable)zzll2);
                throw new IllegalStateException(zzll2);
            }
        }
    }

    private final String getId() {
        this.zzm();
        return this.zzbw.zzaj();
    }

    public final int hashCode() {
        this.zzm();
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.zzbw.zzak().getVersion()});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbl)) {
            return false;
        }
        zzbl zzbl2 = (zzbl)((Object)object);
        this.zzm();
        zzbl2.zzm();
        return this.getId().equals(zzbl2.getId()) && this.zzbw.zzak().getVersion() == zzbl2.zzbw.zzak().getVersion();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzbl zzbl2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        zzbl zzbl3 = zzbl2;
        byte[] byArray = zzbl3.zzbx;
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)2, (byte[])(zzbl3.zzbx != null ? byArray : zzbl3.zzbw.toByteArray()), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        this.zzm();
        return this.zzbw.toString();
    }
}

