/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.awareness.fence.AwarenessFence;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.contextmanager.zzbm;
import com.google.android.gms.internal.contextmanager.zzbp;
import com.google.android.gms.internal.contextmanager.zzbt;
import com.google.android.gms.internal.contextmanager.zzby;
import com.google.android.gms.internal.contextmanager.zzcp;
import com.google.android.gms.internal.contextmanager.zzcq;
import com.google.android.gms.internal.contextmanager.zzcr;
import com.google.android.gms.internal.contextmanager.zzct;
import com.google.android.gms.internal.contextmanager.zzek;
import com.google.android.gms.internal.contextmanager.zzk;
import com.google.android.gms.internal.contextmanager.zzkm;
import com.google.android.gms.internal.contextmanager.zzlb;
import com.google.android.gms.internal.contextmanager.zzll;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="ContextFenceStubCreator")
public final class zzbz
extends AwarenessFence {
    public static final Parcelable.Creator<zzbz> CREATOR = new zzby();
    @SafeParcelable.Field(id=2, getter="getContextFenceProtoAsBytes", type="byte[]")
    private zzek zzcj;
    private byte[] zzck;

    public static zzbz zzb(Collection<zzbz> collection) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0);
        zzek zzek2 = (zzek)((zzlb)zzek.zzap().zzb(zzek.zzb.zzih).zzb(zzbz.zzd(collection)).zzdn());
        return new zzbz(zzek2);
    }

    public static zzbz zzc(Collection<zzbz> collection) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0);
        zzek zzek2 = (zzek)((zzlb)zzek.zzap().zzb(zzek.zzb.zzii).zzb(zzbz.zzd(collection)).zzdn());
        return new zzbz(zzek2);
    }

    public static zzbz zza(zzbz zzbz2) {
        Preconditions.checkNotNull((Object)((Object)zzbz2));
        zzek zzek2 = (zzek)((zzlb)zzek.zzap().zzb(zzek.zzb.zzij).zzb(zzbz2.zzs()).zzdn());
        return new zzbz(zzek2);
    }

    public static zzbz zza(zzcq zzcq2) {
        Preconditions.checkNotNull((Object)zzcq2);
        zzek.zza zza2 = zzcq2.zzv().zzbl() ? zzek.zzap().zzb(zzek.zzb.zzja).zzd(zzcq2.zzv()) : zzek.zzap().zzb(zzek.zzb.zzik).zzc(zzcq2.zzv());
        return new zzbz((zzek)((zzlb)zza2.zzdn()));
    }

    public static zzbz zza(zzcp zzcp2) {
        Preconditions.checkNotNull((Object)zzcp2);
        zzek zzek2 = (zzek)((zzlb)zzek.zzap().zzb(zzek.zzb.zzil).zzb(zzcp2.zzu()).zzdn());
        return new zzbz(zzek2);
    }

    public static zzbz zza(zzbm zzbm2) {
        Preconditions.checkNotNull((Object)zzbm2);
        zzek zzek2 = (zzek)((zzlb)zzek.zzap().zzb(zzek.zzb.zzin).zzb(zzbm2.zzn()).zzdn());
        return new zzbz(zzek2);
    }

    public static zzbz zza(zzbp zzbp2) {
        Preconditions.checkNotNull((Object)zzbp2);
        zzek zzek2 = (zzek)((zzlb)zzek.zzap().zzb(zzek.zzb.zzir).zzb(zzbp2.zzq()).zzdn());
        return new zzbz(zzek2);
    }

    public static zzbz zza(zzbt zzbt2) {
        Preconditions.checkNotNull((Object)zzbt2);
        zzek zzek2 = (zzek)((zzlb)zzek.zzap().zzb(zzek.zzb.zzis).zzb(zzbt2.zzr()).zzdn());
        return new zzbz(zzek2);
    }

    public static zzbz zza(zzct zzct2) {
        Preconditions.checkNotNull((Object)zzct2);
        zzek zzek2 = (zzek)((zzlb)zzek.zzap().zzb(zzek.zzb.zziv).zzb(zzct2.zzx()).zzdn());
        return new zzbz(zzek2);
    }

    public static zzbz zza(zzcr zzcr2) {
        Preconditions.checkNotNull((Object)zzcr2);
        zzek zzek2 = (zzek)((zzlb)zzek.zzap().zzb(zzek.zzb.zziz).zzb(zzcr2.zzw()).zzdn());
        return new zzbz(zzek2);
    }

    private static List<zzek> zzd(Collection<zzbz> collection) {
        ArrayList<zzek> arrayList = new ArrayList<zzek>(collection.size());
        for (zzbz zzbz2 : collection) {
            arrayList.add(zzbz2.zzs());
        }
        return arrayList;
    }

    @SafeParcelable.Constructor
    public zzbz(@SafeParcelable.Param(id=2) byte[] byArray) {
        this.zzcj = null;
        this.zzck = byArray;
        this.zzt();
    }

    private zzbz(zzek zzek2) {
        this.zzcj = (zzek)Preconditions.checkNotNull((Object)zzek2);
        this.zzck = null;
        this.zzt();
    }

    private final zzek zzs() {
        this.zzm();
        return this.zzcj;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzbz zzbz2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        zzbz zzbz3 = zzbz2;
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)2, (byte[])(zzbz3.zzck != null ? zzbz3.zzck : zzbz3.zzcj.toByteArray()), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        this.zzm();
        return this.zzcj.toString();
    }

    private final void zzm() {
        if (!(this.zzcj != null)) {
            try {
                this.zzcj = zzek.zzc(this.zzck, zzkm.zzcx());
                this.zzck = null;
            }
            catch (zzll zzll2) {
                zzk.zza("ContextFenceStub", "Could not deserialize context fence bytes.", (Object)zzll2);
                throw new IllegalStateException(zzll2);
            }
        }
        this.zzt();
    }

    private final void zzt() {
        if (this.zzcj == null && this.zzck != null) {
            return;
        }
        if (this.zzcj != null && this.zzck == null) {
            return;
        }
        if (this.zzcj != null && this.zzck != null) {
            throw new IllegalStateException("Invalid internal representation - full");
        }
        if (this.zzcj == null && this.zzck == null) {
            throw new IllegalStateException("Invalid internal representation - empty");
        }
        throw new IllegalStateException("Impossible");
    }
}

