/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzjn;
import com.google.android.gms.internal.contextmanager.zzlc;
import com.google.android.gms.internal.contextmanager.zzli;
import com.google.android.gms.internal.contextmanager.zzmx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzkx
extends zzjn<Float>
implements zzli<Float>,
zzmx,
RandomAccess {
    private static final zzkx zzacu = new zzkx(new float[0], 0);
    private float[] zzacv;
    private int size;

    zzkx() {
        this(new float[10], 0);
    }

    private zzkx(float[] fArray, int n) {
        this.zzacv = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzacv, n2, this.zzacv, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzkx)) {
            return super.equals(object);
        }
        zzkx zzkx2 = (zzkx)object;
        if (this.size != zzkx2.size) {
            return false;
        }
        float[] fArray = zzkx2.zzacv;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzacv[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzacv[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzcj();
        if (this.size == this.zzacv.length) {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzacv, 0, fArray, 0, this.size);
            this.zzacv = fArray;
        }
        this.zzacv[this.size++] = f;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzcj();
        zzlc.checkNotNull(collection);
        if (!(collection instanceof zzkx)) {
            return super.addAll(collection);
        }
        zzkx zzkx2 = (zzkx)collection;
        if (zzkx2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzkx2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzkx2.size;
        if (n > this.zzacv.length) {
            this.zzacv = Arrays.copyOf(this.zzacv, n);
        }
        System.arraycopy(zzkx2.zzacv, 0, this.zzacv, this.size, zzkx2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzacv[i]))) continue;
            System.arraycopy(this.zzacv, i + 1, this.zzacv, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzat(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzau(n));
        }
    }

    private final String zzau(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzkx zzkx2 = this;
        zzkx2.zzcj();
        zzkx2.zzat(n);
        float f3 = zzkx2.zzacv[n];
        zzkx2.zzacv[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzkx zzkx2 = this;
        zzkx2.zzcj();
        zzkx2.zzat(n);
        float f = zzkx2.zzacv[n];
        if (n < zzkx2.size - 1) {
            System.arraycopy(zzkx2.zzacv, n + 1, zzkx2.zzacv, n, zzkx2.size - n - 1);
        }
        --zzkx2.size;
        ++zzkx2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzkx zzkx2 = this;
        zzkx2.zzcj();
        if (n < 0 || n > zzkx2.size) {
            throw new IndexOutOfBoundsException(zzkx2.zzau(n));
        }
        if (zzkx2.size < zzkx2.zzacv.length) {
            System.arraycopy(zzkx2.zzacv, n, zzkx2.zzacv, n + 1, zzkx2.size - n);
        } else {
            float[] fArray = new float[zzkx2.size * 3 / 2 + 1];
            System.arraycopy(zzkx2.zzacv, 0, fArray, 0, n);
            System.arraycopy(zzkx2.zzacv, n, fArray, n + 1, zzkx2.size - n);
            zzkx2.zzacv = fArray;
        }
        zzkx2.zzacv[n] = f2;
        ++zzkx2.size;
        ++zzkx2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Float f = (Float)object;
        this.zzc(f.floatValue());
        return true;
    }

    @Override
    public final /* synthetic */ zzli zzav(int n) {
        int n2 = n;
        zzkx zzkx2 = this;
        if (n2 < zzkx2.size) {
            throw new IllegalArgumentException();
        }
        return new zzkx(Arrays.copyOf(zzkx2.zzacv, n2), zzkx2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzkx zzkx2 = this;
        zzkx2.zzat(n);
        return Float.valueOf(zzkx2.zzacv[n]);
    }

    static {
        zzacu.zzci();
    }
}

