/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzjn;
import com.google.android.gms.internal.contextmanager.zzlc;
import com.google.android.gms.internal.contextmanager.zzli;
import com.google.android.gms.internal.contextmanager.zzmx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzlz
extends zzjn<Long>
implements zzli<Long>,
zzmx,
RandomAccess {
    private static final zzlz zzafo = new zzlz(new long[0], 0);
    private long[] zzafp;
    private int size;

    zzlz() {
        this(new long[10], 0);
    }

    private zzlz(long[] lArray, int n) {
        this.zzafp = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzafp, n2, this.zzafp, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzlz)) {
            return super.equals(object);
        }
        zzlz zzlz2 = (zzlz)object;
        if (this.size != zzlz2.size) {
            return false;
        }
        long[] lArray = zzlz2.zzafp;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzafp[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzlc.zzz(this.zzafp[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzat(n);
        return this.zzafp[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzaa(long l) {
        this.zzcj();
        if (this.size == this.zzafp.length) {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzafp, 0, lArray, 0, this.size);
            this.zzafp = lArray;
        }
        this.zzafp[this.size++] = l;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzcj();
        zzlc.checkNotNull(collection);
        if (!(collection instanceof zzlz)) {
            return super.addAll(collection);
        }
        zzlz zzlz2 = (zzlz)collection;
        if (zzlz2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzlz2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzlz2.size;
        if (n > this.zzafp.length) {
            this.zzafp = Arrays.copyOf(this.zzafp, n);
        }
        System.arraycopy(zzlz2.zzafp, 0, this.zzafp, this.size, zzlz2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzafp[i])) continue;
            System.arraycopy(this.zzafp, i + 1, this.zzafp, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzat(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzau(n));
        }
    }

    private final String zzau(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzlz zzlz2 = this;
        zzlz2.zzcj();
        zzlz2.zzat(n);
        long l3 = zzlz2.zzafp[n];
        zzlz2.zzafp[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzlz zzlz2 = this;
        zzlz2.zzcj();
        zzlz2.zzat(n);
        long l = zzlz2.zzafp[n];
        if (n < zzlz2.size - 1) {
            System.arraycopy(zzlz2.zzafp, n + 1, zzlz2.zzafp, n, zzlz2.size - n - 1);
        }
        --zzlz2.size;
        ++zzlz2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzlz zzlz2 = this;
        zzlz2.zzcj();
        if (n < 0 || n > zzlz2.size) {
            throw new IndexOutOfBoundsException(zzlz2.zzau(n));
        }
        if (zzlz2.size < zzlz2.zzafp.length) {
            System.arraycopy(zzlz2.zzafp, n, zzlz2.zzafp, n + 1, zzlz2.size - n);
        } else {
            long[] lArray = new long[zzlz2.size * 3 / 2 + 1];
            System.arraycopy(zzlz2.zzafp, 0, lArray, 0, n);
            System.arraycopy(zzlz2.zzafp, n, lArray, n + 1, zzlz2.size - n);
            zzlz2.zzafp = lArray;
        }
        zzlz2.zzafp[n] = l2;
        ++zzlz2.size;
        ++zzlz2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        this.zzaa(l);
        return true;
    }

    @Override
    public final /* synthetic */ zzli zzav(int n) {
        int n2 = n;
        zzlz zzlz2 = this;
        if (n2 < zzlz2.size) {
            throw new IllegalArgumentException();
        }
        return new zzlz(Arrays.copyOf(zzlz2.zzafp, n2), zzlz2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzafo.zzci();
    }
}

