/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.contextmanager.zzay;
import com.google.android.gms.internal.contextmanager.zzk;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="WeatherImplCreator")
public final class zzaw
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzaw> CREATOR = new zzay();
    @SafeParcelable.Field(id=2, getter="getTemperatureFahrenheit")
    private final float zzax;
    @SafeParcelable.Field(id=3, getter="getFeelsLikeTemperatureFahrenheit")
    private final float zzay;
    @SafeParcelable.Field(id=4, getter="getDewPointFahrenheit")
    private final float zzaz;
    @SafeParcelable.Field(id=5, getter="getHumidity")
    private final int zzba;
    @SafeParcelable.Field(id=6, getter="getConditions")
    private final int[] zzbb;

    @SafeParcelable.Constructor
    public zzaw(@SafeParcelable.Param(id=2) float f, @SafeParcelable.Param(id=3) float f2, @SafeParcelable.Param(id=4) float f3, @SafeParcelable.Param(id=5) int n, @SafeParcelable.Param(id=6) int[] nArray) {
        this.zzax = f;
        this.zzay = f2;
        this.zzaz = f3;
        this.zzba = n;
        this.zzbb = nArray;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzaw zzaw2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)2, (float)zzaw2.zzax);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)3, (float)zzaw2.zzay);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)4, (float)zzaw2.zzaz);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)5, (int)zzaw2.zzba);
        SafeParcelWriter.writeIntArray((Parcel)parcel2, (int)6, (int[])zzaw2.zzbb, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private final float zza(int n) {
        return zzaw.zza(n, this.zzaz);
    }

    private final float zzb(int n) {
        return zzaw.zza(n, this.zzay);
    }

    private final float zzc(int n) {
        return zzaw.zza(n, this.zzax);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Temp=").append(this.zzc(1)).append("F/").append(this.zzc(2)).append("C, Feels=").append(this.zzb(1)).append("F/").append(this.zzb(2)).append("C, Dew=").append(this.zza(1)).append("F/").append(this.zza(2)).append("C, Humidity=").append(this.zzba).append(", Condition=");
        if (this.zzbb == null) {
            stringBuilder.append("unknown");
        } else {
            stringBuilder.append("[");
            boolean bl = true;
            int[] nArray = this.zzbb;
            int n = this.zzbb.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                if (!bl) {
                    stringBuilder.append(",");
                }
                bl = false;
                stringBuilder.append(n2);
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static float zza(int n, float f) {
        switch (n) {
            case 1: {
                return f;
            }
            case 2: {
                float f2 = f;
                return 5.0f * (f2 - 32.0f) / 9.0f;
            }
        }
        zzk.zza("WeatherImpl", "Invalid temperature unit %s", (Object)n);
        throw new IllegalArgumentException("Invalid temperature unit");
    }
}

