/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.contextmanager.zzaz;
import com.google.android.gms.internal.contextmanager.zzdq;
import com.google.android.gms.internal.contextmanager.zzkd;
import com.google.android.gms.internal.contextmanager.zzkz;
import com.google.android.gms.internal.contextmanager.zzn;

@SafeParcelable.Reserved(value={1})
@ShowFirstParty
@VisibleForTesting
@SafeParcelable.Class(creator="ContextDataCreator")
public final class zzba
extends AbstractSafeParcelable {
    private static zzn zzbc = null;
    private static final int[] zzbd = new int[]{0, 1};
    public static final Parcelable.Creator<zzba> CREATOR = new zzaz();
    @SafeParcelable.Field(id=2, getter="getContextProtoAsBytes", type="byte[]")
    private zzdq zzbe = null;
    private byte[] zzbf;

    @SafeParcelable.Constructor
    public zzba(@SafeParcelable.Param(id=2) byte[] byArray) {
        this.zzbf = (byte[])Preconditions.checkNotNull((Object)byArray);
        zzba zzba2 = this;
        if (!(zzba2.zzbe == null && zzba2.zzbf != null || zzba2.zzbe != null && zzba2.zzbf == null)) {
            if (zzba2.zzbe != null && zzba2.zzbf != null) {
                throw new IllegalStateException("Invalid internal representation - full");
            }
            if (zzba2.zzbe == null && zzba2.zzbf == null) {
                throw new IllegalStateException("Invalid internal representation - empty");
            }
            throw new IllegalStateException("Impossible");
        }
    }

    private final void zzk() {
        if (!(this.zzbe != null)) {
            byte[] byArray = this.zzbf;
            if (this.zzbf == null) {
                return;
            }
            try {
                this.zzbe = zzdq.zzb(byArray, zzkd.zzcv());
                this.zzbf = null;
                return;
            }
            catch (zzkz zzkz2) {
                Log.e((String)"ContextData", (String)"Could not deserialize context bytes.", (Throwable)zzkz2);
                throw new IllegalStateException(zzkz2);
            }
        }
    }

    private final String getId() {
        this.zzk();
        return this.zzbe.zzah();
    }

    public final int hashCode() {
        this.zzk();
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.zzbe.zzai().getVersion()});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzba)) {
            return false;
        }
        zzba zzba2 = (zzba)((Object)object);
        this.zzk();
        zzba2.zzk();
        return this.getId().equals(zzba2.getId()) && this.zzbe.zzai().getVersion() == zzba2.zzbe.zzai().getVersion();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzba zzba2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        zzba zzba3 = zzba2;
        byte[] byArray = zzba3.zzbf;
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)2, (byte[])(zzba3.zzbf != null ? byArray : zzba3.zzbe.toByteArray()), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        this.zzk();
        return this.zzbe.toString();
    }
}

