/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.awareness.fence.AwarenessFence;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.contextmanager.zzbb;
import com.google.android.gms.internal.contextmanager.zzbe;
import com.google.android.gms.internal.contextmanager.zzbi;
import com.google.android.gms.internal.contextmanager.zzbn;
import com.google.android.gms.internal.contextmanager.zzce;
import com.google.android.gms.internal.contextmanager.zzcf;
import com.google.android.gms.internal.contextmanager.zzcg;
import com.google.android.gms.internal.contextmanager.zzci;
import com.google.android.gms.internal.contextmanager.zzdz;
import com.google.android.gms.internal.contextmanager.zzk;
import com.google.android.gms.internal.contextmanager.zzkd;
import com.google.android.gms.internal.contextmanager.zzkq;
import com.google.android.gms.internal.contextmanager.zzkz;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="ContextFenceStubCreator")
public final class zzbo
extends AwarenessFence {
    public static final Parcelable.Creator<zzbo> CREATOR = new zzbn();
    @SafeParcelable.Field(id=2, getter="getContextFenceProtoAsBytes", type="byte[]")
    private zzdz zzbr;
    private byte[] zzbs;

    public static zzbo zzb(Collection<zzbo> collection) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0);
        zzdz zzdz2 = (zzdz)((zzkq)zzdz.zzan().zzb(zzdz.zzb.zzhq).zzb(zzbo.zzd(collection)).zzds());
        return new zzbo(zzdz2);
    }

    public static zzbo zzc(Collection<zzbo> collection) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0);
        zzdz zzdz2 = (zzdz)((zzkq)zzdz.zzan().zzb(zzdz.zzb.zzhr).zzb(zzbo.zzd(collection)).zzds());
        return new zzbo(zzdz2);
    }

    public static zzbo zza(zzbo zzbo2) {
        Preconditions.checkNotNull((Object)((Object)zzbo2));
        zzdz zzdz2 = (zzdz)((zzkq)zzdz.zzan().zzb(zzdz.zzb.zzhs).zzb(zzbo2.zzq()).zzds());
        return new zzbo(zzdz2);
    }

    public static zzbo zza(zzcf zzcf2) {
        Preconditions.checkNotNull((Object)zzcf2);
        zzdz.zza zza2 = zzcf2.zzt().zzbj() ? zzdz.zzan().zzb(zzdz.zzb.zzij).zzd(zzcf2.zzt()) : zzdz.zzan().zzb(zzdz.zzb.zzht).zzc(zzcf2.zzt());
        return new zzbo((zzdz)((zzkq)zza2.zzds()));
    }

    public static zzbo zza(zzce zzce2) {
        Preconditions.checkNotNull((Object)zzce2);
        zzdz zzdz2 = (zzdz)((zzkq)zzdz.zzan().zzb(zzdz.zzb.zzhu).zzb(zzce2.zzs()).zzds());
        return new zzbo(zzdz2);
    }

    public static zzbo zza(zzbb zzbb2) {
        Preconditions.checkNotNull((Object)zzbb2);
        zzdz zzdz2 = (zzdz)((zzkq)zzdz.zzan().zzb(zzdz.zzb.zzhw).zzb(zzbb2.zzl()).zzds());
        return new zzbo(zzdz2);
    }

    public static zzbo zza(zzbe zzbe2) {
        Preconditions.checkNotNull((Object)zzbe2);
        zzdz zzdz2 = (zzdz)((zzkq)zzdz.zzan().zzb(zzdz.zzb.zzia).zzb(zzbe2.zzo()).zzds());
        return new zzbo(zzdz2);
    }

    public static zzbo zza(zzbi zzbi2) {
        Preconditions.checkNotNull((Object)zzbi2);
        zzdz zzdz2 = (zzdz)((zzkq)zzdz.zzan().zzb(zzdz.zzb.zzib).zzb(zzbi2.zzp()).zzds());
        return new zzbo(zzdz2);
    }

    public static zzbo zza(zzci zzci2) {
        Preconditions.checkNotNull((Object)zzci2);
        zzdz zzdz2 = (zzdz)((zzkq)zzdz.zzan().zzb(zzdz.zzb.zzie).zzb(zzci2.zzv()).zzds());
        return new zzbo(zzdz2);
    }

    public static zzbo zza(zzcg zzcg2) {
        Preconditions.checkNotNull((Object)zzcg2);
        zzdz zzdz2 = (zzdz)((zzkq)zzdz.zzan().zzb(zzdz.zzb.zzii).zzb(zzcg2.zzu()).zzds());
        return new zzbo(zzdz2);
    }

    private static List<zzdz> zzd(Collection<zzbo> collection) {
        ArrayList<zzdz> arrayList = new ArrayList<zzdz>(collection.size());
        for (zzbo zzbo2 : collection) {
            arrayList.add(zzbo2.zzq());
        }
        return arrayList;
    }

    @SafeParcelable.Constructor
    public zzbo(@SafeParcelable.Param(id=2) byte[] byArray) {
        this.zzbr = null;
        this.zzbs = byArray;
        this.zzr();
    }

    private zzbo(zzdz zzdz2) {
        this.zzbr = (zzdz)Preconditions.checkNotNull((Object)zzdz2);
        this.zzbs = null;
        this.zzr();
    }

    private final zzdz zzq() {
        this.zzk();
        return this.zzbr;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzbo zzbo2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        zzbo zzbo3 = zzbo2;
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)2, (byte[])(zzbo3.zzbs != null ? zzbo3.zzbs : zzbo3.zzbr.toByteArray()), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        this.zzk();
        return this.zzbr.toString();
    }

    private final void zzk() {
        if (!(this.zzbr != null)) {
            try {
                this.zzbr = zzdz.zzc(this.zzbs, zzkd.zzcv());
                this.zzbs = null;
            }
            catch (zzkz zzkz2) {
                zzk.zza("ContextFenceStub", "Could not deserialize context fence bytes.", (Object)zzkz2);
                throw new IllegalStateException(zzkz2);
            }
        }
        this.zzr();
    }

    private final void zzr() {
        if (this.zzbr == null && this.zzbs != null) {
            return;
        }
        if (this.zzbr != null && this.zzbs == null) {
            return;
        }
        if (this.zzbr != null && this.zzbs != null) {
            throw new IllegalStateException("Invalid internal representation - full");
        }
        if (this.zzbr == null && this.zzbs == null) {
            throw new IllegalStateException("Invalid internal representation - empty");
        }
        throw new IllegalStateException("Impossible");
    }
}

