/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzjb;
import com.google.android.gms.internal.contextmanager.zzku;
import com.google.android.gms.internal.contextmanager.zzla;
import com.google.android.gms.internal.contextmanager.zzml;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzkc
extends zzjb<Double>
implements zzla<Double>,
zzml,
RandomAccess {
    private static final zzkc zzzi = new zzkc(new double[0], 0);
    private double[] zzzj;
    private int size;

    zzkc() {
        this(new double[10], 0);
    }

    private zzkc(double[] dArray, int n) {
        this.zzzj = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcg();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzzj, n2, this.zzzj, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzkc)) {
            return super.equals(object);
        }
        zzkc zzkc2 = (zzkc)object;
        if (this.size != zzkc2.size) {
            return false;
        }
        double[] dArray = zzkc2.zzzj;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzzj[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzzj[i]);
            n = n * 31 + zzku.zzz(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzg(double d) {
        this.zzcg();
        if (this.size == this.zzzj.length) {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzzj, 0, dArray, 0, this.size);
            this.zzzj = dArray;
        }
        this.zzzj[this.size++] = d;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzcg();
        zzku.checkNotNull(collection);
        if (!(collection instanceof zzkc)) {
            return super.addAll(collection);
        }
        zzkc zzkc2 = (zzkc)collection;
        if (zzkc2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzkc2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzkc2.size;
        if (n > this.zzzj.length) {
            this.zzzj = Arrays.copyOf(this.zzzj, n);
        }
        System.arraycopy(zzkc2.zzzj, 0, this.zzzj, this.size, zzkc2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcg();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzzj[i])) continue;
            System.arraycopy(this.zzzj, i + 1, this.zzzj, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaw(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzax(n));
        }
    }

    private final String zzax(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzkc zzkc2 = this;
        zzkc2.zzcg();
        zzkc2.zzaw(n);
        double d3 = zzkc2.zzzj[n];
        zzkc2.zzzj[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzkc zzkc2 = this;
        zzkc2.zzcg();
        zzkc2.zzaw(n);
        double d = zzkc2.zzzj[n];
        if (n < zzkc2.size - 1) {
            System.arraycopy(zzkc2.zzzj, n + 1, zzkc2.zzzj, n, zzkc2.size - n - 1);
        }
        --zzkc2.size;
        ++zzkc2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzkc zzkc2 = this;
        zzkc2.zzcg();
        if (n < 0 || n > zzkc2.size) {
            throw new IndexOutOfBoundsException(zzkc2.zzax(n));
        }
        if (zzkc2.size < zzkc2.zzzj.length) {
            System.arraycopy(zzkc2.zzzj, n, zzkc2.zzzj, n + 1, zzkc2.size - n);
        } else {
            double[] dArray = new double[zzkc2.size * 3 / 2 + 1];
            System.arraycopy(zzkc2.zzzj, 0, dArray, 0, n);
            System.arraycopy(zzkc2.zzzj, n, dArray, n + 1, zzkc2.size - n);
            zzkc2.zzzj = dArray;
        }
        zzkc2.zzzj[n] = d2;
        ++zzkc2.size;
        ++zzkc2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Double d = (Double)object;
        this.zzg(d);
        return true;
    }

    @Override
    public final /* synthetic */ zzla zzay(int n) {
        int n2 = n;
        zzkc zzkc2 = this;
        if (n2 < zzkc2.size) {
            throw new IllegalArgumentException();
        }
        return new zzkc(Arrays.copyOf(zzkc2.zzzj, n2), zzkc2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzkc zzkc2 = this;
        zzkc2.zzaw(n);
        return zzkc2.zzzj[n];
    }

    static {
        zzzi.zzcf();
    }
}

