/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzjb;
import com.google.android.gms.internal.contextmanager.zzku;
import com.google.android.gms.internal.contextmanager.zzla;
import com.google.android.gms.internal.contextmanager.zzml;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzkp
extends zzjb<Float>
implements zzla<Float>,
zzml,
RandomAccess {
    private static final zzkp zzacm = new zzkp(new float[0], 0);
    private float[] zzacn;
    private int size;

    zzkp() {
        this(new float[10], 0);
    }

    private zzkp(float[] fArray, int n) {
        this.zzacn = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcg();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzacn, n2, this.zzacn, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzkp)) {
            return super.equals(object);
        }
        zzkp zzkp2 = (zzkp)object;
        if (this.size != zzkp2.size) {
            return false;
        }
        float[] fArray = zzkp2.zzacn;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzacn[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzacn[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzcg();
        if (this.size == this.zzacn.length) {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzacn, 0, fArray, 0, this.size);
            this.zzacn = fArray;
        }
        this.zzacn[this.size++] = f;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzcg();
        zzku.checkNotNull(collection);
        if (!(collection instanceof zzkp)) {
            return super.addAll(collection);
        }
        zzkp zzkp2 = (zzkp)collection;
        if (zzkp2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzkp2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzkp2.size;
        if (n > this.zzacn.length) {
            this.zzacn = Arrays.copyOf(this.zzacn, n);
        }
        System.arraycopy(zzkp2.zzacn, 0, this.zzacn, this.size, zzkp2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcg();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzacn[i]))) continue;
            System.arraycopy(this.zzacn, i + 1, this.zzacn, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaw(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzax(n));
        }
    }

    private final String zzax(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzkp zzkp2 = this;
        zzkp2.zzcg();
        zzkp2.zzaw(n);
        float f3 = zzkp2.zzacn[n];
        zzkp2.zzacn[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzkp zzkp2 = this;
        zzkp2.zzcg();
        zzkp2.zzaw(n);
        float f = zzkp2.zzacn[n];
        if (n < zzkp2.size - 1) {
            System.arraycopy(zzkp2.zzacn, n + 1, zzkp2.zzacn, n, zzkp2.size - n - 1);
        }
        --zzkp2.size;
        ++zzkp2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzkp zzkp2 = this;
        zzkp2.zzcg();
        if (n < 0 || n > zzkp2.size) {
            throw new IndexOutOfBoundsException(zzkp2.zzax(n));
        }
        if (zzkp2.size < zzkp2.zzacn.length) {
            System.arraycopy(zzkp2.zzacn, n, zzkp2.zzacn, n + 1, zzkp2.size - n);
        } else {
            float[] fArray = new float[zzkp2.size * 3 / 2 + 1];
            System.arraycopy(zzkp2.zzacn, 0, fArray, 0, n);
            System.arraycopy(zzkp2.zzacn, n, fArray, n + 1, zzkp2.size - n);
            zzkp2.zzacn = fArray;
        }
        zzkp2.zzacn[n] = f2;
        ++zzkp2.size;
        ++zzkp2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Float f = (Float)object;
        this.zzc(f.floatValue());
        return true;
    }

    @Override
    public final /* synthetic */ zzla zzay(int n) {
        int n2 = n;
        zzkp zzkp2 = this;
        if (n2 < zzkp2.size) {
            throw new IllegalArgumentException();
        }
        return new zzkp(Arrays.copyOf(zzkp2.zzacn, n2), zzkp2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzkp zzkp2 = this;
        zzkp2.zzaw(n);
        return Float.valueOf(zzkp2.zzacn[n]);
    }

    static {
        zzacm.zzcf();
    }
}

