/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzjb;
import com.google.android.gms.internal.contextmanager.zzku;
import com.google.android.gms.internal.contextmanager.zzky;
import com.google.android.gms.internal.contextmanager.zzla;
import com.google.android.gms.internal.contextmanager.zzml;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzks
extends zzjb<Integer>
implements zzky,
zzml,
RandomAccess {
    private static final zzks zzade = new zzks(new int[0], 0);
    private int[] zzadf;
    private int size;

    public static zzks zzdu() {
        return zzade;
    }

    zzks() {
        this(new int[10], 0);
    }

    private zzks(int[] nArray, int n) {
        this.zzadf = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcg();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzadf, n2, this.zzadf, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzks)) {
            return super.equals(object);
        }
        zzks zzks2 = (zzks)object;
        if (this.size != zzks2.size) {
            return false;
        }
        int[] nArray = zzks2.zzadf;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzadf[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzadf[i];
        }
        return n;
    }

    @Override
    public final zzky zzbt(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzks(Arrays.copyOf(this.zzadf, n), this.size);
    }

    public final int getInt(int n) {
        this.zzaw(n);
        return this.zzadf[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzbu(int n) {
        this.zzcg();
        if (this.size == this.zzadf.length) {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzadf, 0, nArray, 0, this.size);
            this.zzadf = nArray;
        }
        this.zzadf[this.size++] = n;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzcg();
        zzku.checkNotNull(collection);
        if (!(collection instanceof zzks)) {
            return super.addAll(collection);
        }
        zzks zzks2 = (zzks)collection;
        if (zzks2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzks2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzks2.size;
        if (n > this.zzadf.length) {
            this.zzadf = Arrays.copyOf(this.zzadf, n);
        }
        System.arraycopy(zzks2.zzadf, 0, this.zzadf, this.size, zzks2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcg();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzadf[i])) continue;
            System.arraycopy(this.zzadf, i + 1, this.zzadf, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaw(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzax(n));
        }
    }

    private final String zzax(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzks zzks2 = this;
        zzks2.zzcg();
        zzks2.zzaw(n);
        int n4 = zzks2.zzadf[n];
        zzks2.zzadf[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzks zzks2 = this;
        zzks2.zzcg();
        zzks2.zzaw(n);
        int n2 = zzks2.zzadf[n];
        if (n < zzks2.size - 1) {
            System.arraycopy(zzks2.zzadf, n + 1, zzks2.zzadf, n, zzks2.size - n - 1);
        }
        --zzks2.size;
        ++zzks2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzks zzks2 = this;
        zzks2.zzcg();
        if (n < 0 || n > zzks2.size) {
            throw new IndexOutOfBoundsException(zzks2.zzax(n));
        }
        if (zzks2.size < zzks2.zzadf.length) {
            System.arraycopy(zzks2.zzadf, n, zzks2.zzadf, n + 1, zzks2.size - n);
        } else {
            int[] nArray = new int[zzks2.size * 3 / 2 + 1];
            System.arraycopy(zzks2.zzadf, 0, nArray, 0, n);
            System.arraycopy(zzks2.zzadf, n, nArray, n + 1, zzks2.size - n);
            zzks2.zzadf = nArray;
        }
        zzks2.zzadf[n] = n3;
        ++zzks2.size;
        ++zzks2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Integer n = (Integer)object;
        this.zzbu(n);
        return true;
    }

    @Override
    public final /* synthetic */ zzla zzay(int n) {
        return this.zzbt(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzade.zzcf();
    }
}

