/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzjb;
import com.google.android.gms.internal.contextmanager.zzku;
import com.google.android.gms.internal.contextmanager.zzla;
import com.google.android.gms.internal.contextmanager.zzml;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzln
extends zzjb<Long>
implements zzla<Long>,
zzml,
RandomAccess {
    private static final zzln zzaex = new zzln(new long[0], 0);
    private long[] zzaey;
    private int size;

    zzln() {
        this(new long[10], 0);
    }

    private zzln(long[] lArray, int n) {
        this.zzaey = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcg();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzaey, n2, this.zzaey, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzln)) {
            return super.equals(object);
        }
        zzln zzln2 = (zzln)object;
        if (this.size != zzln2.size) {
            return false;
        }
        long[] lArray = zzln2.zzaey;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzaey[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzku.zzz(this.zzaey[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzaw(n);
        return this.zzaey[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzaa(long l) {
        this.zzcg();
        if (this.size == this.zzaey.length) {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzaey, 0, lArray, 0, this.size);
            this.zzaey = lArray;
        }
        this.zzaey[this.size++] = l;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzcg();
        zzku.checkNotNull(collection);
        if (!(collection instanceof zzln)) {
            return super.addAll(collection);
        }
        zzln zzln2 = (zzln)collection;
        if (zzln2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzln2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzln2.size;
        if (n > this.zzaey.length) {
            this.zzaey = Arrays.copyOf(this.zzaey, n);
        }
        System.arraycopy(zzln2.zzaey, 0, this.zzaey, this.size, zzln2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcg();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzaey[i])) continue;
            System.arraycopy(this.zzaey, i + 1, this.zzaey, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaw(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzax(n));
        }
    }

    private final String zzax(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzln zzln2 = this;
        zzln2.zzcg();
        zzln2.zzaw(n);
        long l3 = zzln2.zzaey[n];
        zzln2.zzaey[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzln zzln2 = this;
        zzln2.zzcg();
        zzln2.zzaw(n);
        long l = zzln2.zzaey[n];
        if (n < zzln2.size - 1) {
            System.arraycopy(zzln2.zzaey, n + 1, zzln2.zzaey, n, zzln2.size - n - 1);
        }
        --zzln2.size;
        ++zzln2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzln zzln2 = this;
        zzln2.zzcg();
        if (n < 0 || n > zzln2.size) {
            throw new IndexOutOfBoundsException(zzln2.zzax(n));
        }
        if (zzln2.size < zzln2.zzaey.length) {
            System.arraycopy(zzln2.zzaey, n, zzln2.zzaey, n + 1, zzln2.size - n);
        } else {
            long[] lArray = new long[zzln2.size * 3 / 2 + 1];
            System.arraycopy(zzln2.zzaey, 0, lArray, 0, n);
            System.arraycopy(zzln2.zzaey, n, lArray, n + 1, zzln2.size - n);
            zzln2.zzaey = lArray;
        }
        zzln2.zzaey[n] = l2;
        ++zzln2.size;
        ++zzln2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        this.zzaa(l);
        return true;
    }

    @Override
    public final /* synthetic */ zzla zzay(int n) {
        int n2 = n;
        zzln zzln2 = this;
        if (n2 < zzln2.size) {
            throw new IllegalArgumentException();
        }
        return new zzln(Arrays.copyOf(zzln2.zzaey, n2), zzln2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzaex.zzcf();
    }
}

