/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzaj;
import com.google.android.gms.common.internal.zzak;
import com.google.android.gms.dynamic.zzf;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    public static final int COLOR_AUTO = 2;
    private int mSize;
    private int mColor;
    private View zzayF;
    private View.OnClickListener zzayG = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SignInButton(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzb(context, attributeSet);
        this.setStyle(this.mSize, this.mColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.SignInButton, 0, 0);
        try {
            this.mSize = typedArray.getInt(R.styleable.SignInButton_buttonSize, 0);
            this.mColor = typedArray.getInt(R.styleable.SignInButton_colorScheme, 2);
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setSize(int n) {
        this.setStyle(n, this.mColor);
    }

    public void setColorScheme(int n) {
        this.setStyle(this.mSize, n);
    }

    @Deprecated
    public void setScopes(Scope[] scopeArray) {
        this.setStyle(this.mSize, this.mColor);
    }

    public void setStyle(int n, int n2) {
        this.mSize = n;
        this.mColor = n2;
        this.zzaO(this.getContext());
    }

    @Deprecated
    public void setStyle(int n, int n2, Scope[] scopeArray) {
        this.setStyle(n, n2);
    }

    private void zzaO(Context context) {
        if (this.zzayF != null) {
            this.removeView(this.zzayF);
        }
        try {
            this.zzayF = zzaj.zzd(context, this.mSize, this.mColor);
        }
        catch (zzf.zza zza2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.zzayF = SignInButton.zzc(context, this.mSize, this.mColor);
        }
        this.addView(this.zzayF);
        this.zzayF.setEnabled(this.isEnabled());
        this.zzayF.setOnClickListener((View.OnClickListener)this);
    }

    private static Button zzc(Context context, int n, int n2) {
        zzak zzak2 = new zzak(context);
        zzak2.zza(context.getResources(), n, n2);
        return zzak2;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzayG = onClickListener;
        if (this.zzayF != null) {
            this.zzayF.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.zzayF.setEnabled(bl);
    }

    public void onClick(View view) {
        if (this.zzayG != null && view == this.zzayF) {
            this.zzayG.onClick((View)this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorScheme {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ButtonSize {
    }
}

