/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaag;
import com.google.android.gms.internal.zzaaj;
import com.google.android.gms.internal.zzaat;
import com.google.android.gms.internal.zzaax;
import com.google.android.gms.internal.zzabc;
import com.google.android.gms.internal.zzabq;
import com.google.android.gms.internal.zzadb;
import com.google.android.gms.internal.zzbai;
import com.google.android.gms.internal.zzbaj;
import com.google.android.gms.internal.zzzz;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzaak
implements zzabc {
    private final Map<Api.zzc<?>, zzaaj<?>> zzaAM = new HashMap();
    private final Map<Api.zzc<?>, zzaaj<?>> zzaAN = new HashMap();
    private final Map<Api<?>, Boolean> zzaAO;
    private final zzaax zzayX;
    private final zzaat zzaAP;
    private final Lock zzaAG;
    private final Looper zzrs;
    private final zze zzaAQ;
    private final Condition zzaAR;
    private final zzg zzaAL;
    private final boolean zzaAS;
    private final boolean zzaAT;
    private final Queue<zzaad.zza<?, ?>> zzaAU = new LinkedList();
    private boolean zzaAV;
    private Map<zzzz<?>, ConnectionResult> zzaAW;
    private Map<zzzz<?>, ConnectionResult> zzaAX;
    private zzb zzaAY;
    private ConnectionResult zzaAZ;

    public zzaak(Context context, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzbai, zzbaj> zza2, ArrayList<zzaag> arrayList, zzaat zzaat2, boolean bl) {
        boolean bl2;
        this.zzaAG = lock;
        this.zzrs = looper;
        this.zzaAR = lock.newCondition();
        this.zzaAQ = zze2;
        this.zzaAP = zzaat2;
        this.zzaAO = map2;
        this.zzaAL = zzg2;
        this.zzaAS = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> object : map2.keySet()) {
            hashMap.put(object.zzvg(), object);
        }
        HashMap hashMap2 = new HashMap();
        for (zzaag zzaag2 : arrayList) {
            hashMap2.put(zzaag2.zzaxf, zzaag2);
        }
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze3 = entry.getValue();
            if (zze3.zzvh()) {
                bl5 = true;
                if (!this.zzaAO.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl4 = false;
            }
            zzaag zzaag3 = (zzaag)hashMap2.get(api);
            zzaaj zzaaj2 = new zzaaj(context, api, looper, zze3, zzaag3, zzg2, zza2);
            this.zzaAM.put(entry.getKey(), zzaaj2);
            if (!zze3.zzrd()) continue;
            this.zzaAN.put(entry.getKey(), zzaaj2);
        }
        this.zzaAT = bl5 && !bl4 && !bl2;
        this.zzayX = zzaax.zzww();
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzaad.zza<R, A>> T zza(@NonNull T t) {
        if (this.zzaAS && this.zzd(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zzaAU.add(t);
            return t;
        }
        this.zzaAP.zzaBW.zzb(t);
        return this.zzaAM.get(t.zzvg()).doRead(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzaad.zza<? extends Result, A>> T zzb(@NonNull T t) {
        Api.zzc<A> zzc2 = t.zzvg();
        if (this.zzaAS && this.zzd(t)) {
            return t;
        }
        this.zzaAP.zzaBW.zzb(t);
        return this.zzaAM.get(zzc2).doWrite(t);
    }

    private <T extends zzaad.zza<? extends Result, ? extends Api.zzb>> boolean zzd(@NonNull T t) {
        Api.zzc<? extends Api.zzb> zzc2 = t.zzvg();
        ConnectionResult connectionResult = this.zzb(zzc2);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.zzB(new Status(4, null, this.zzayX.zza(this.zzaAM.get(zzc2).getApiKey(), this.zzaAP.getSessionId())));
            return true;
        }
        return false;
    }

    @Override
    public void connect() {
        this.zzaAG.lock();
        try {
            if (this.zzaAV) {
                return;
            }
            this.zzaAV = true;
            this.zzaAW = null;
            this.zzaAX = null;
            this.zzaAY = null;
            this.zzaAZ = null;
            this.zzayX.zzvx();
            this.zzayX.zza(this.zzaAM.values()).addOnCompleteListener((Executor)new zzadb(this.zzrs), (OnCompleteListener)new zza());
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzaAR.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzayj;
        }
        if (this.zzaAZ != null) {
            return this.zzaAZ;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzaAR.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzayj;
        }
        if (this.zzaAZ != null) {
            return this.zzaAZ;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public void disconnect() {
        this.zzaAG.lock();
        try {
            this.zzaAV = false;
            this.zzaAW = null;
            this.zzaAX = null;
            if (this.zzaAY != null) {
                this.zzaAY.cancel();
                this.zzaAY = null;
            }
            this.zzaAZ = null;
            while (!this.zzaAU.isEmpty()) {
                zzaad.zza<?, ?> zza2 = this.zzaAU.remove();
                zza2.zza(null);
                zza2.cancel();
            }
            this.zzaAR.signalAll();
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zzb(api.zzvg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ConnectionResult zzb(@NonNull Api.zzc<?> zzc2) {
        this.zzaAG.lock();
        try {
            zzaaj<?> zzaaj2 = this.zzaAM.get(zzc2);
            if (this.zzaAW != null && zzaaj2 != null) {
                ConnectionResult connectionResult = this.zzaAW.get(zzaaj2.getApiKey());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public boolean isConnected() {
        this.zzaAG.lock();
        try {
            boolean bl = this.zzaAW != null && this.zzaAZ == null;
            return bl;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public boolean isConnecting() {
        this.zzaAG.lock();
        try {
            boolean bl = this.zzaAW == null && this.zzaAV;
            return bl;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzvN() {
        this.zzaAG.lock();
        try {
            if (!this.zzaAV || !this.zzaAS) {
                return false;
            }
            for (Api.zzc<?> zzc2 : this.zzaAN.keySet()) {
                ConnectionResult connectionResult = this.zzb(zzc2);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public boolean zza(zzabq zzabq2) {
        this.zzaAG.lock();
        try {
            if (this.zzaAV && !this.zzvN()) {
                this.zzayX.zzvx();
                this.zzaAY = new zzb(zzabq2);
                this.zzayX.zza(this.zzaAN.values()).addOnCompleteListener((Executor)new zzadb(this.zzrs), (OnCompleteListener)this.zzaAY);
                return true;
            }
            return false;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzvn() {
        this.zzaAG.lock();
        try {
            this.zzayX.zzvn();
            if (this.zzaAY != null) {
                this.zzaAY.cancel();
                this.zzaAY = null;
            }
            if (this.zzaAX == null) {
                this.zzaAX = new ArrayMap(this.zzaAN.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzaaj<?> zzaaj2 : this.zzaAN.values()) {
                this.zzaAX.put(zzaaj2.getApiKey(), connectionResult);
            }
            if (this.zzaAW != null) {
                this.zzaAW.putAll(this.zzaAX);
            }
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public void zzvM() {
    }

    private void zzvV() {
        if (this.zzaAL == null) {
            this.zzaAP.zzaBR = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzaAL.zzxL());
        Map<Api<?>, zzg.zza> map = this.zzaAL.zzxN();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).zzakq);
        }
        this.zzaAP.zzaBR = hashSet;
    }

    private void zzvW() {
        while (!this.zzaAU.isEmpty()) {
            this.zzb(this.zzaAU.remove());
        }
        this.zzaAP.zzo(null);
    }

    private boolean zza(zzaaj<?> zzaaj2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzaAO.get(zzaaj2.getApi()) != false && zzaaj2.zzvU().zzvh() && this.zzaAQ.isUserResolvableError(connectionResult.getErrorCode());
    }

    @Nullable
    private ConnectionResult zzvX() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzaaj<?> zzaaj2 : this.zzaAM.values()) {
            int n3;
            Api api = zzaaj2.getApi();
            zzzz zzzz2 = zzaaj2.getApiKey();
            ConnectionResult connectionResult3 = this.zzaAW.get(zzzz2);
            if (connectionResult3.isSuccess() || this.zzaAO.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzaAQ.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzaAS) {
                n3 = api.zzve().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zzve().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    private class zzb
    implements OnCompleteListener<Void> {
        private zzabq zzaBb;

        zzb(zzabq zzabq2) {
            this.zzaBb = zzabq2;
        }

        void cancel() {
            this.zzaBb.zzrq();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(@NonNull Task<Void> task) {
            zzaak.this.zzaAG.lock();
            try {
                if (!zzaak.this.zzaAV) {
                    this.zzaBb.zzrq();
                    return;
                }
                if (task.isSuccessful()) {
                    zzaak.this.zzaAX = (Map)new ArrayMap(zzaak.this.zzaAN.size());
                    for (zzaaj zzaaj2 : zzaak.this.zzaAN.values()) {
                        zzaak.this.zzaAX.put(zzaaj2.getApiKey(), ConnectionResult.zzayj);
                    }
                } else if (task.getException() instanceof com.google.android.gms.common.api.zzb) {
                    com.google.android.gms.common.api.zzb zzb2 = (com.google.android.gms.common.api.zzb)task.getException();
                    if (zzaak.this.zzaAT) {
                        zzaak.this.zzaAX = (Map)new ArrayMap(zzaak.this.zzaAN.size());
                        for (zzaaj zzaaj3 : zzaak.this.zzaAN.values()) {
                            zzzz zzzz2 = zzaaj3.getApiKey();
                            ConnectionResult connectionResult = zzb2.zza(zzaaj3);
                            if (zzaak.this.zza(zzaaj3, connectionResult)) {
                                zzaak.this.zzaAX.put(zzzz2, new ConnectionResult(16));
                                continue;
                            }
                            zzaak.this.zzaAX.put(zzzz2, connectionResult);
                        }
                    } else {
                        zzaak.this.zzaAX = zzb2.zzvj();
                    }
                } else {
                    Log.e((String)"ConnectionlessGAC", (String)"Unexpected availability exception", (Throwable)task.getException());
                    zzaak.this.zzaAX = Collections.emptyMap();
                }
                if (zzaak.this.isConnected()) {
                    zzaak.this.zzaAW.putAll(zzaak.this.zzaAX);
                    if (zzaak.this.zzvX() == null) {
                        zzaak.this.zzvV();
                        zzaak.this.zzvW();
                        zzaak.this.zzaAR.signalAll();
                    }
                }
                this.zzaBb.zzrq();
            }
            finally {
                zzaak.this.zzaAG.unlock();
            }
        }
    }

    private class zza
    implements OnCompleteListener<Void> {
        private zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(@NonNull Task<Void> task) {
            zzaak.this.zzaAG.lock();
            try {
                if (!zzaak.this.zzaAV) {
                    return;
                }
                if (task.isSuccessful()) {
                    zzaak.this.zzaAW = (Map)new ArrayMap(zzaak.this.zzaAM.size());
                    for (zzaaj zzaaj2 : zzaak.this.zzaAM.values()) {
                        zzaak.this.zzaAW.put(zzaaj2.getApiKey(), ConnectionResult.zzayj);
                    }
                } else if (task.getException() instanceof com.google.android.gms.common.api.zzb) {
                    com.google.android.gms.common.api.zzb zzb2 = (com.google.android.gms.common.api.zzb)task.getException();
                    if (zzaak.this.zzaAT) {
                        zzaak.this.zzaAW = (Map)new ArrayMap(zzaak.this.zzaAM.size());
                        for (zzaaj zzaaj3 : zzaak.this.zzaAM.values()) {
                            zzzz zzzz2 = zzaaj3.getApiKey();
                            ConnectionResult connectionResult = zzb2.zza(zzaaj3);
                            if (zzaak.this.zza(zzaaj3, connectionResult)) {
                                zzaak.this.zzaAW.put(zzzz2, new ConnectionResult(16));
                                continue;
                            }
                            zzaak.this.zzaAW.put(zzzz2, connectionResult);
                        }
                    } else {
                        zzaak.this.zzaAW = zzb2.zzvj();
                    }
                    zzaak.this.zzaAZ = zzaak.this.zzvX();
                } else {
                    Log.e((String)"ConnectionlessGAC", (String)"Unexpected availability exception", (Throwable)task.getException());
                    zzaak.this.zzaAW = Collections.emptyMap();
                    zzaak.this.zzaAZ = new ConnectionResult(8);
                }
                if (zzaak.this.zzaAX != null) {
                    zzaak.this.zzaAW.putAll(zzaak.this.zzaAX);
                    zzaak.this.zzaAZ = zzaak.this.zzvX();
                }
                if (zzaak.this.zzaAZ == null) {
                    zzaak.this.zzvV();
                    zzaak.this.zzvW();
                } else {
                    zzaak.this.zzaAV = false;
                    zzaak.this.zzaAP.zzc(zzaak.this.zzaAZ);
                }
                zzaak.this.zzaAR.signalAll();
            }
            finally {
                zzaak.this.zzaAG.unlock();
            }
        }
    }
}

