/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaaf;
import com.google.android.gms.internal.zzabo;
import com.google.android.gms.internal.zzabp;
import java.lang.ref.WeakReference;

public class zzabx<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzaDl = null;
    private zzabx<? extends Result> zzaDm = null;
    private volatile ResultCallbacks<? super R> zzaDn = null;
    private PendingResult<R> zzaDo = null;
    private final Object zzaAh = new Object();
    private Status zzaDp = null;
    private final WeakReference<GoogleApiClient> zzaAj;
    private final zza zzaDq;
    private boolean zzaDr = false;

    public zzabx(WeakReference<GoogleApiClient> weakReference) {
        zzac.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzaAj = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzaAj.get();
        this.zzaDq = new zza(googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzaAh;
        synchronized (object) {
            zzac.zza((this.zzaDl == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzac.zza((this.zzaDn == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaDl = resultTransform;
            zzabx<R> zzabx2 = new zzabx<R>(this.zzaAj);
            this.zzaDm = zzabx2;
            this.zzxa();
            return zzabx2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzaAh;
        synchronized (object) {
            zzac.zza((this.zzaDn == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzac.zza((this.zzaDl == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaDn = resultCallbacks;
            this.zzxa();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(R r) {
        Object object = this.zzaAh;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzaDl != null) {
                    zzabo.zzwv().submit(new Runnable((Result)r){
                        final /* synthetic */ Result zzaDs;
                        {
                            this.zzaDs = result;
                        }

                        @Override
                        @WorkerThread
                        public void run() {
                            try {
                                zzaaf.zzaAg.set(true);
                                PendingResult pendingResult = zzabx.this.zzaDl.onSuccess(this.zzaDs);
                                zzabx.this.zzaDq.sendMessage(zzabx.this.zzaDq.obtainMessage(0, pendingResult));
                            }
                            catch (RuntimeException runtimeException) {
                                zzabx.this.zzaDq.sendMessage(zzabx.this.zzaDq.obtainMessage(1, runtimeException));
                            }
                            finally {
                                zzaaf.zzaAg.set(false);
                                zzabx.this.zzd(this.zzaDs);
                                GoogleApiClient googleApiClient = (GoogleApiClient)zzabx.this.zzaAj.get();
                                if (googleApiClient != null) {
                                    googleApiClient.zzb(zzabx.this);
                                }
                            }
                        }
                    });
                } else if (this.zzxc()) {
                    this.zzaDn.onSuccess(r);
                }
            } else {
                this.zzE(r.getStatus());
                this.zzd((Result)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(PendingResult<?> pendingResult) {
        Object object = this.zzaAh;
        synchronized (object) {
            this.zzaDo = pendingResult;
            this.zzxa();
        }
    }

    private void zzxa() {
        if (this.zzaDl == null && this.zzaDn == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzaAj.get();
        if (!this.zzaDr && this.zzaDl != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzaDr = true;
        }
        if (this.zzaDp != null) {
            this.zzF(this.zzaDp);
        } else if (this.zzaDo != null) {
            this.zzaDo.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzE(Status status) {
        Object object = this.zzaAh;
        synchronized (object) {
            this.zzaDp = status;
            this.zzF(this.zzaDp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzF(Status status) {
        Object object = this.zzaAh;
        synchronized (object) {
            if (this.zzaDl != null) {
                Status status2 = this.zzaDl.onFailure(status);
                zzac.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzE(status2);
            } else if (this.zzxc()) {
                this.zzaDn.onFailure(status);
            }
        }
    }

    void zzxb() {
        this.zzaDn = null;
    }

    private boolean zzxc() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzaAj.get();
        return this.zzaDn != null && googleApiClient != null;
    }

    private void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zza
    extends Handler {
        public zza(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    PendingResult pendingResult = (PendingResult)message.obj;
                    Object object = zzabx.this.zzaAh;
                    synchronized (object) {
                        if (pendingResult == null) {
                            ((zzabx)zzabx.this.zzaDm).zzE(new Status(13, "Transform returned null"));
                        } else if (pendingResult instanceof zzabp) {
                            ((zzabx)zzabx.this.zzaDm).zzE(((zzabp)pendingResult).getStatus());
                        } else {
                            zzabx.this.zzaDm.zza(pendingResult);
                        }
                        break;
                    }
                }
                case 1: {
                    RuntimeException runtimeException = (RuntimeException)message.obj;
                    String string2 = String.valueOf(runtimeException.getMessage());
                    Log.e((String)"TransformedResultImpl", (String)(string2.length() != 0 ? "Runtime exception on the transformation worker thread: ".concat(string2) : new String("Runtime exception on the transformation worker thread: ")));
                    throw runtimeException;
                }
                default: {
                    int n = message.what;
                    Log.e((String)"TransformedResultImpl", (String)new StringBuilder(70).append("TransformationResultHandler received unknown message type: ").append(n).toString());
                }
            }
        }
    }
}

